#include "mbed.h"
 
I2C i2c(p28,p27);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
char cmd[32];
int i, j, k;
int sw;
 
void set_ch(char sel)
{    // PCA9541のサンプル
        // MST_0側の自分にスレーブ側の制御権を得る場合
    cmd[0] = 1;                     // PCA9541 コマンドコード Cont Reg
    i2c.write( 0xe2, cmd, 1);       // Cont Regを指定
    i2c.read( 0xe2, cmd, 1);        // Cont Regを読込み
    wait(0.1);                      // 0.1s待つ
    switch(cmd[0] & 0xf)
    {
    case 0:                         // bus off, has control
    case 1:                         // bus off, no control
    case 5:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 4;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 2:                         // bus off, no control
    case 3:                         // bus off, has control
    case 6:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 5;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 9:                         // bus on, no control
    case 0xc:                       // bus on, no control
    case 0xd:                       // bus off, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 0;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 0xa:                       // bus on, no control
    case 0xe:                       // bus off, no control
    case 0xf:                       // bus on, has control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 1;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    default:
        break;
    }

    cmd[0] = sel;                   // PCA9546 Cont Reg sel channel enabled
    i2c.write( 0xe8, cmd, 1);       // Send command string
}

int main ()
{
    i2c.frequency(100000);
    pc.printf("PCA9541A Sample Program\r\n");

    set_ch(1);              // PCA9541Aによりマスターを選択後
                            // PCA9546によりchｎに接続
    
  // PCA9541A
    while(1);
}
