#include "mbed.h"
#include "USBSerial.h"
#include "DDS.h"


USBSerial pc;


// sin()関数で合成された方形波
float square13(float x)
{
    return (4*(sin(x) + sin(3*x)/3. + sin(5*x)/5. + sin(7*x)/7. + sin(9*x)/9. + 
       sin(11*x)/11. + sin(13*x)/13.))/PI;
}

// 円の方程式から作られる半円波形
float circle(float x)
{
    return sqrt(1 - (x - PI)*(x - PI)/PI/PI);
}

// 高調波を含んだsin()関数
float sin2(float x)
{
    return (sin(x) + sin(5*x)/3)/1.3;
}

// float x を引数としてfloatを返す関数へのポインタの配列
float (*ftbl[])(float x) = {sin, triangle, square, circle, sin2};

// 簡単な操作説明
void help(void)
{
    pc.printf("o1 freq phase level offset func\r\n");
    pc.printf("b1 begin end length DcLevel\r\n");
    pc.printf("o2 freq phase level offset func\r\n");
    pc.printf("b2 begin end length DcLevel\r\n");
    pc.printf("h ... help\r\n");
 }

int main(){

    // インスタンスの生成
    DDS dds;
    // 出力１の波形設定
    dds.osc1(1000, 0, 0.5, 1, sin);
    dds.burst1(2, 2, 2, 1);

    dds.osc2(1000, 0, 0.5, 2, sin);
    dds.burst2(1, 1, 2, 2);

    dds.reset();
    dds.start();
    
    pc.printf("\r\n>");
    while(1){
        switch(pc.getc()){
            case 'h':
                help();
                break;
            case 'o':
                float a, b, c, o;
                int n;
                if(pc.getc() == '1'){
                    pc.printf(" osc1: ");
                    pc.scanf("%f %f %f %f %d", &a, &b, &c, &o, &n);
                    dds.osc1(a, b, c, o, ftbl[n]);
                }else{
                    pc.printf(" osc2: ");
                    pc.scanf("%f %f %f %f %d", &a, &b, &c, &o, &n);
                    dds.osc2(a, b, c, o, ftbl[n]);
                }
                dds.reset();
                break;
            case 'b':
                int bg, en, ln;
                float dc;
                if(pc.getc() == '1'){
                    pc.printf(" bust1: ");
                    pc.scanf("%d %d %d %f", &bg, &en, &ln, &dc);
                    dds.burst1(bg, en, ln, dc);
                }else{
                    pc.printf(" bust2: ");
                    pc.scanf("%d %d %d %f", &bg, &en, &ln, &dc);
                    dds.burst2(bg, en, ln, dc);
                }
                dds.reset();
                break;
            default:
                continue;
        }
        pc.printf("\r\n>");
    } 
}

