#ifndef DDS_h
#define DDS_h

#define PACCLEN (4294967296.0)      // 位相積算レジスタの最大値 2^23
#define PI (3.1415926535897932385)  // 円周率

// 出力電圧の設定
#define VCC (3.27)          // 電源電圧、実測
#define BUFMAG (2.0)        // 出力バッファの増幅率
#define WFMAG (1.0/(VCC*BUFMAG))    // PWM値算出のための係数 

class DDS {
private:
    static const int MAINCLK = 48000000;    // CPUのシステムクロック値
    static const int DDSCLK  =   100000;    // DDSの基準クロック値
    static const int TBLSIZEBITS = 10;          // 波形配列の長さを決めるビット数
    static const int WFVGND = 0;                // バースト波形の無信号状態の出力値
    // 以下は上の値から設定されるので変更不可
    static const int TBLSIZE = 1 << TBLSIZEBITS;// 波形配列の長さ
    static const int WFRES = 32 - TBLSIZEBITS;  // 位相積算レジスタを波形配列の引数に変換するためのビットシフト値
    static const int WFVSPN = MAINCLK / DDSCLK; // PWMの最大値

    static int16_t waveForm1[];
    static int16_t waveForm2[];

    static unsigned int phaseAcc1;
    static unsigned int phaseInc1;
    static unsigned int phaseShift1;
    static int bstBgn1;
    static int bstEnd1;
    static int bstLen1;
    static int bstDcL1;
    static int wc1;
    static int lp1;

    static unsigned int phaseAcc2;
    static unsigned int phaseInc2;
    static unsigned int phaseShift2;
    static int bstBgn2;
    static int bstEnd2;
    static int bstLen2;
    static int bstDcL2;
    static int wc2;
    static int lp2;

    void fillTable(int16_t wftbl[], float level, float ofst, float (*waveform)(float x));

public:
    static int trigger1;
    static int trigger2;

    DDS();
    static void start(void);
    static void stop(void);
    static void reset(void);
    int getPhase(void){
        return phaseAcc1;
    };
    static inline int getNextPw1(void);
    static inline int getNextPw2(void);
    void osc1(float freq, float phase, float level, float ofst, float (*waveform)(float x));
    void osc1(float freq, float phase);
    void osc2(float freq, float phase, float level, float ofst, float (*waveform)(float x));
    void osc2(float freq, float phase);
    void burst1(int begin, int end, int length, float dcLevel);
    void burst2(int begin, int end, int length, float dcLevel);
};

float triangle(float x);
float square(float x);



#endif
