#include "mbed.h"
#include "USBSerial.h"
#include "AD7714.h"
#include "Thermistor.h"
#include "ExpAvr.h"


int main() {

    int fsample = 5;        // AD7714サンプリング周波数
    float LPFcut = 0.01;    // LPFカットオフ周波数
    
    USBSerial serial;   // PCとの通信ポート
    
    // AD7714によるレシオメトリック測定オブジェクト
    // (+)入力Vdd側抵抗値、(-)入力Vdd側抵抗値、同GND側抵抗値、リファレンス入力Vdd側抵抗値、同GND側抵抗値
    RatioMetric7714 resistorAdc(9988, 9976, 9942, 9956, 9830);
    // フィルタノッチ周波数（出力更新レート）の設定
    resistorAdc.setFilter(fsample);
    
    // サーミスタオブジェクト
    // B定数、基準温度、基準温度でのサーミスタ抵抗値
    Thermistor tsensor(3480.0, 25.0, 5369.0);
    // ２次式による補正のための設定
    tsensor.adjust(1.7, 0.5, 58.9, 57.0, 77.0, 73.0);
    
    // 指数平均によるLPFオブジェクト、４次フィルタ
    ExpAvr LPF(4, LPFcut, fsample);
    
    serial.printf("self cal finished.  OK!\r\n");
    serial.printf("Rs Temp LPF\r\n");

    int cnt = 0;
    while(1){
        // 変換終了を待つ
        while(resistorAdc.isBusy()){
        }
        // サーミスタの抵抗値を得る
        double r = resistorAdc.getResistorValue();
        // 抵抗値を温度値に変換
        double t = tsensor.toTempValue(r);
        // LPF処理
        double v = LPF.getOutput(t);
        // 出力更新レートに関わらず１Hz毎に測定結果を出力
        if(cnt++ == fsample){
            cnt = 0;
            serial.printf("%7.2f, %6.4f, %6.4f\n\r", r, t, v);
        }
    }
}
