#ifndef THERMISTOR_H
#define THERMISTOR_H

/// サーミスタクラス
/// AD変換結果から温度を算出する
#define ABSTMP (273.0)
class Thermistor {
private:
    double b;   ///< B定数
    double t0;  ///< 上記B定数となる温度
    double rs0; ///< 上記温度での抵抗値
    double t;
    double a2, a1, a0;  /// 補正多項式の係数
public:
    /// コンストラクタ
    Thermistor(double B, double T0, double Rs0);

    /// ２次式による補正係数を決定
    void adjust(double t1, double t1r, double t2, double t2r, double t3, double t3r);
    /// １次式による補正係数を決定
    void adjust(double t1, double t1r, double t2, double t2r);

    /// 抵抗値を温度値に変換する
    double toTempValue(double rval);
};
        



#endif
