#ifndef EXPAVR_H
#define EXPAVR_H

#include <math.h>

#define MathPi (3.1415926535897932384626433832795)
/// 指数平均を計算する（実質的なローパスフィルタ）
class ExpAvr {
private:
    int order;      ///< ローパスフィルタの次数に相当
    double tc;      ///< 指数平均への増分、CR時定数に相当
    double *acc;    ///< 中間値を保存
    bool first;     ///< 初期化が必要かどうかのフラグ
public:
    /// コンストラクタ
    /// @param order 次数（フィルタの段数）
    /// @param fcutoff カットオフ周波数[Hz]、fsampleより十分小さいこと。1/10以下を推奨。
    /// @param fsample サンプリング周波数[Hz]
    ExpAvr(int order, double fcutoff, double fsample){
        this->order = order;
        this->tc = exp((-2*fcutoff*MathPi)/fsample);
        acc = new double[order];
        first = true;
    };
    /// 指数平均計算
    /// @param d フィルタの入力値
    /// @return フィルタの出力値
    double getOutput(double d);
};


#endif
