//
// HD44780 type 4bit parallel LCD control
//
#include "mbed.h"

DigitalOut LCDRS(P0_3);     // LCD module Register Select
DigitalOut LCDE(P0_1);      // LCD module Enable
DigitalOut LCDD4(P1_19);     // LCD data lines(4bit)
DigitalOut LCDD5(P0_5);
DigitalOut LCDD6(P0_4);
DigitalOut LCDD7(P1_15);

void enable( void )
{
  wait_us( 1 );
  LCDE = 1;
  wait_us( 1 );
  LCDE = 0;
  wait_us( 1 );
}

void lcd_set4bit( unsigned char d )
{
  LCDD4 = d & 0x01;
  LCDD5 = d & 0x02;
  LCDD6 = d & 0x04;
  LCDD7 = d & 0x08;
}

void lcd_write4bit( unsigned char d )
{
  lcd_set4bit( d );
  enable();
}

void LCD_cmd( char c )
{
  LCDRS = 0;
  lcd_write4bit( c / 16 );
  lcd_write4bit( c & 0x0f );
  wait_us( 30 );
}

void LCD_data( char d )
{
  LCDRS = 1;
  lcd_write4bit( d / 16 );
  lcd_write4bit( d & 0x0f );
  wait_us( 30 );
}

void LCD_puts( char *s )
{
  while( *s ) LCD_data( *s++ );
}

void LCD_iniz( void )
{
  LCDE = 0;
  LCDRS = 0;
  wait_ms( 40 );    // wait 40mS
  lcd_write4bit( 0x03 );
  wait_ms( 5 );
  lcd_write4bit( 0x03 );
  wait_ms( 2 );
  lcd_write4bit( 0x03 );
  wait_ms( 2 );
  lcd_write4bit( 0x02 );    // 4bit interface select
  LCD_cmd( 0x28 );      // 2 lines 5x8 chr.
  LCD_cmd( 0x08 );      // display off
  LCD_cmd( 0x01 );      // display clear
  wait_ms( 2 );
  LCD_cmd( 0x06 );      // entry mode
  LCD_cmd( 0x0C );      // display on
}

