/**
 *  @file       Main.cpp
 *  @brief      Send pulse waveform and pulse rate 
 *  @date       2014.08.08
 *  @version    1.0.0
 */
#include "mbed.h"
#include "USBSerial.h"
#include "PulseRate.h"

#define PACKET_HEADER (0xAA)
#define PULSE_RATE_ID (0xBB)
#define BYTE_MASK (0xFF)

USBSerial serial;
PulseRate pr(p20, LED1, p26); /* AD, LED, Beep */

/** Send data packet
 *  @param      second_val  Byte data at packet address 0x01
 *  @param      data_val    Short data at packet address 0x02, 0x03
 */
bool send_packet(int second_val, int data_val)
{
    if(serial.writeable()) {
        serial.putc(PACKET_HEADER);
        serial.putc(second_val & BYTE_MASK);
        serial.putc((data_val >> 8 ) & BYTE_MASK);
        serial.putc(data_val & BYTE_MASK);
        return true;
    }
    else
    {
        return false;
    }
}

/** Main function
 */
int main() {
    uint32_t num;
    int32_t wave;
    uint32_t rate;
    
    pr.start_sampling();    /* start procedure */

    while(1) {
        /* Pulse waveform */
        if(pr.get_wave(num, wave)) {
            send_packet(num, wave);
        }
        /* Pulse rate */
        if(pr.get_pr_val(rate)) {
            send_packet(PULSE_RATE_ID, rate);
        }
    }
}
