#include "mbed.h"
#include "ATP3012.h"

Serial bluetooth(p9,p10); //tx, rx
ATP3012 talk(P0_5, P0_4); // sda, scl

PwmOut Rin(P0_8); 
PwmOut Lin(P0_9);
PwmOut S40kHz(P0_21);
DigitalOut IN1(P0_11);
DigitalOut IN2(P0_12);
AnalogIn Ain(P0_13);
DigitalOut StopSignal(P0_20);
DigitalOut Light(P0_16);

int main() {
    bluetooth.baud(115200);
    int32_t i, j;
    int32_t count=10000;
    uint8_t buf='5';
    char moji[64];
    int32_t onsei=0;

    char* LightOn[64] = { "raitoon.\r", "tentou.\r" } ;
    char* LightOff[64] = { "raito/ohu.\r", "syoutou.\r" } ;
    char* Forward[64] = { "susume.\r", "<ALPHA VAL=start>.\r" } ;
    char* Stop[64] = { "tomare.\r", "<ALPHA VAL=stop>.\r" } ;     
    char* Backward[64] = { "sagare.\r", "bakku.\r" } ;     
    char* LeftTurn[64] = { "<ALPHA VAL=left>.\r", "sasetu.\r" } ;     
    char* RightTurn[64] = { "raito.\r", "usetu.\r" } ;     
    char* LeftBackward[64] = { "hidariusiro.\r", "usiro /hidari.\r" };
    char* RightBackward[64] = { "migiusiro.\r", "usiro /migi.\r" };
    char* LeftOblique[64] = { "naname/hidari.\r","hidari/naname.\r" };
    char* RightOblique[64] = { "naname/migi.\r","migi/naname.\r" }; 
    char* Acceleration[64] = { "hayaku.\r","supi-do/appu.\r" };
    char* Deceleration[64] = { "osoku.\r","supi-do/daun.\r" }; 

    float speed=0;
    float Rdata=1;
    float Ldata=1;
    float threshold=0.2;
    S40kHz.period_us(25);          // 40kHz
    S40kHz.pulsewidth_us(12.5);
    Light=0;
    j = count;
    
    talk.Synthe("sumahode,ennbextudo'ka-o/ugoka'_su+koto'ga/dekima'_su.\r");
    talk.Synthe("ta'xtu_chi+shite/ugoka'_shite+mi'te+kudasa'i.\r");
    talk.Synthe("mata shabe'ttemo/je'_sucha-demo/ugokasema'_su.\r");
    talk.Synthe("ma'zuwa buru-twu'-suni/setsuzo_kushimasho'-.\r");
         
    while (1) {
        if(bluetooth.readable()) {
            i=0;
            do {
                buf=bluetooth.getc();
                moji[i++]=buf;
            } while(buf!='\0');
            buf=moji[0];
        }
        for(int i = 0; i <= 1; i++) {
            if (strcmp(LeftBackward[i],moji) == 0) buf='1';
            if (strcmp(Backward[i],moji) == 0) buf='2';
            if (strcmp(RightBackward[i],moji) == 0) buf='3';
            if (strcmp(LeftTurn[i],moji) == 0) buf='4';            
            if (strcmp(Stop[i],moji) == 0) buf='5';
            if (strcmp(RightTurn[i],moji) == 0) buf='6';        
            if (strcmp(LeftOblique[i],moji) == 0) buf='7';
            if (strcmp(Forward[i],moji) == 0) buf='8';
            if (strcmp(RightOblique[i],moji) == 0) buf='9';
            if (strcmp(LightOn[i],moji) == 0) buf='+';           
            if (strcmp(LightOff[i],moji) == 0) buf='-';
            if (strcmp(Acceleration[i],moji) == 0) buf='*';           
            if (strcmp(Deceleration[i],moji) == 0) buf='0';
        }          

        if(Ain > threshold) {
            StopSignal=0;   // Red LED ON
            if((buf>='4')){
                buf='5';
                IN1=1;IN2=1; 
                if(onsei==1) {
                    talk.Synthe("zennpo-ni sho-gai'butsuo/hakkennshima'_shita.\r");
                    talk.Synthe("ka'i_hi+shitekudasa'i.\r");   
                    onsei=0;
                }
            }
        } else {
            StopSignal=1;   // Red LED OFF
            onsei=1;
        }
        switch (buf){
        case '1':   // Left Backward
          IN1=1;IN2=0;
            Rdata=0.4+speed; Ldata=0.6+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("hidariusiro.\r");  
            break;
        case '2':   // Backward
           IN1=1;IN2=0;
            Rdata=0.5+speed; Ldata=0.5+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("ushironi/sagarima'_su.\r");  
            break;
        case '3':   // Right Backward
            IN1=1;IN2=0;
            Rdata=0.6+speed; Ldata=0.4+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("migiusiro.\r");   
            break;
        case '4':   // Left Turn
            IN1=0;IN2=1;    
            Rdata=0.3+speed; Ldata=0.8+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("sasetsu.\r");  
            break;
        case '5':   // Stop
            IN1=1;IN2=1;
            break;
        case '6':   // Right Turn
            IN1=0;IN2=1;  
            Rdata=0.8+speed; Ldata=0.3+speed;
            Rin=Rdata; Lin=Ldata;        
            talk.Synthe("usetsu.\r");  
            break;
        case '7':   // Left Oblique
            IN1=0;IN2=1;    
            Rdata=0.4+speed; Ldata=0.6+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("hidarinana'me.\r");  
            break;
        case '8':   // Forward
            IN1=0;IN2=1;
            Rdata=0.5+speed; Ldata=0.5+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("zennshinn.\r");    
            break;
        case '9':   // Right Oblique
            IN1=0;IN2=1;    
            Rdata=0.6+speed; Ldata=0.4+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("miginana'me.\r");  
            break;
        case '+':   //Light On
            Light=1;
            talk.Synthe("#J\r");
            talk.Synthe("ra'itoo/tennto-shima'_su.\r"); 
            break;
        case '-':   //Light Off
            Light=0;
            talk.Synthe("#J\r");
            talk.Synthe("ra'itoo/keshima'_su.\r");            
            break;
        case '0':   // Deceleration
            speed=speed+0.05;
            Rdata=Rdata+speed; Ldata=Ldata+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("gennsoku.\r");                         
            break;
        case '*':   // Acceleration
            speed=speed-0.05;
            Rdata=Rdata+speed; Ldata=Ldata+speed;
            Rin=Rdata; Lin=Ldata;
            talk.Synthe("kasoku.\r");      
            break;            
        default:
            j--;
            if( j == 0) {
                talk.Synthe(" .\r");
                j = count;
            }
            break;
        }
        buf='X';
        moji[0]=0;
    }
}