#include "mbed.h"
#pragma once
 
#define AQTK_I2C_ADDR (0x2E<<1)
#define AQTK_STARTUP_WAIT_MS 80
#define AQTK_POLL_WAIT_MS 10
 
/** ATP3012 class
 *
 * AquesTalk pico LSI I2C interface
 * Example:
 * @code
 *      #include "ATP3012.h"
 *      ATP3012 talk(P0_10,P0_11); // I2C sda scl
 *      
 *      int main() {
 *          talk.Synthe("konnichiwa.");
 *          for(int n = 1; ; n++) {
 *              char buf[32];
 *              snprintf(buf, sizeof(buf), "<NUMK VAL=%d>.", n);
 *              talk.Synthe(buf);
 *          }
 *      } 
 * @endcode
 *
 */
class ATP3012 {
public:
    /** Create a AquesTalk pico LSI I2C interface
     *
     * @param sda  I2C data pin
     * @param scl  I2C clock pin
     * @param addr I2C address
     */
    ATP3012(PinName sda, PinName scl, int addr = AQTK_I2C_ADDR);
    bool IsActive(int timeout_ms = 500);
    void Synthe(const char* msg);
    void Write(const char* msg);
    bool IsBusy();
private:
    int _addr;
    I2C _i2c; 
    Timer _poll_wait;
};

