#include "mbed.h"                   //  for mbed
#include "MARMEX_VB.h"
#include "bmp_handler.h"

#if defined( TARGET_MBED_LPC1768 ) || defined( TARGET_LPC11U24_401 )
LocalFileSystem     local("local"); //  for mbed to access local file system
#endif

#ifdef  RGB565_FORMAT
char bhp[]   = {
    0x42, 0x4d, 0x8a, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x7c, 0x00,
    0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x01, 0x00, 0x10, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x1f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x47, 0x52, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#else
#if 0
char bhp[]   = {
    0x42, 0x4d, 0x8a, 0x8c, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00, 0x00, 0x00, 0x7c, 0x00,
    0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x01, 0x00, 0x20, 0x00, 0x03, 0x00,
    0x00, 0x00, 0x00, 0x8c, 0x01, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x13, 0x0b, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x47, 0x52, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#else
typedef struct  bmp_header_st    {
    unsigned short  bfType            __attribute__((packed));
    unsigned long   bfSize            __attribute__((packed));
    unsigned short  bfReserved1       __attribute__((packed));
    unsigned short  bfReserved2       __attribute__((packed));
    unsigned long   bfOffBits         __attribute__((packed));

    unsigned long   biSize            __attribute__((packed));
    long            biWidth           __attribute__((packed));
    long            biHeight          __attribute__((packed));
    unsigned short  biPlanes          __attribute__((packed));
    unsigned short  biBitCount        __attribute__((packed));
    unsigned long   biCompression     __attribute__((packed));
    unsigned long   biSizeImage       __attribute__((packed));
    long            biXPixPerMeter    __attribute__((packed));
    long            biYPixPerMeter    __attribute__((packed));
    unsigned long   biClrUsed         __attribute__((packed));
    unsigned long   biCirImportant    __attribute__((packed));
}
bmp_header;
#endif
#endif


FILE    *fp;

int open_BMP( char *file_name, int get_horizontal_size, int get_vertical_size )
{
    bmp_header  bh  =   {
        0x4D42,
        get_horizontal_size * get_vertical_size * 4 + 54,
        0,
        0,
        54,
        40,
        get_horizontal_size,
        get_vertical_size,
        1,
        32,
        0,
        get_horizontal_size * get_vertical_size * 4,
        2835,
        2835,
        0,
        0
    };
    char    s[ 80 ];

    sprintf( s, "/local/%s", file_name );

    if ( NULL == (fp    = fopen( s, "wb" )) )
        return 1;

    fwrite( &bh, sizeof( bh ), 1, fp );
//    fwrite( bhp, sizeof( bhp ), 1, fp );

    return 0;
}

void write_BMP( short *p, int length )
{
#ifdef  RGB565_FORMAT
    fwrite( p, sizeof( short ), length, fp );
#else
    unsigned long   v[ length ];
    unsigned long   tmp;

    for ( int i = 0; i < length; i++ ) {
        tmp     = p[ i ];
        //tmp     = 0xF800;
        v[ i ]  = (tmp & 0x001F) << 3;
        v[ i ] |= (tmp & 0x07E0) << 5;
        v[ i ] |= (tmp & 0xF800) << 8;
    }

    fwrite( v, sizeof( unsigned long ), length, fp );
#endif
}

void write_BMP( short *p, int length, char mask )
{
    unsigned long   v[ length ];
    unsigned long   tmp;

    for ( int i = 0; i < length; i++ ) {
        tmp     = p[ i ];
        //tmp     = 0xF800;
        v[ i ]  = (mask & 0x4) ? (tmp & 0x001F) << 3 : 0;
        v[ i ] |= (mask & 0x2) ? (tmp & 0x07E0) << 5 : 0;
        v[ i ] |= (mask & 0x1) ? (tmp & 0xF800) << 8 : 0;
    }

    fwrite( v, sizeof( unsigned long ), length, fp );
}

void close_BMP( void )
{
    fclose( fp );
}


char *read_alpha_BMP( char *file_name, alpha_param *azp )
{
    bmp_header  bh;
    char        s[ 80 ];
    int         data_size;

    sprintf( s, "/local/%s", file_name );

    if ( NULL == (fp    = fopen( s, "rb" )) ) {
        azp->buffer = NULL;
        return NULL;
    }

    fread( &bh, sizeof( bh ), 1, fp );
    azp->h    = bh.biWidth;
    azp->v    = bh.biHeight;
    azp->byte_per_pixel = bh.biBitCount / 8;

    data_size   = sizeof( char ) * azp->h * azp->v * azp->byte_per_pixel;

    fseek( fp, bh.bfOffBits - sizeof( bh ), SEEK_CUR );

    if ( NULL == ( azp->buffer = (char *)malloc( data_size ) ) ) {
        fclose( fp );
        return ( NULL );
    }

    fread( azp->buffer, data_size, 1, fp );
    fclose( fp );

    printf( "alpha image loaded. (from \"%s\", size = %d/%d, %d bytes/pixel)\r\n", s, azp->h, azp->v, azp->byte_per_pixel );

    return azp->buffer;
}