/** Hello program for MARMEX_VB Camera control library
 *
 *  @version 0.1
 *  @date    10-Jun-2014
 *
 *  Released under the Apache License, Version 2.0 : http://mbed.org/handbook/Apache-Licence
 *
 *      ** This program may run on 40pin type mbed platfoms ;) **
 */

#include "mbed.h"
#include "MARMEX_OB_oled.h"
#include "MARMEX_VB.h"

//  Baseboard type selection
#define BASEBOARD_MAPLE_MINI_TYPE_B
//#define BASEBOARD_MAPLE_ORIGINAL

#ifdef  BASEBOARD_MAPLE_MINI_TYPE_B
MARMEX_OB_oled  oled1( p5, p7,  p20, p16, p15 );
// mosi, sclk, cs, rst, power_control               -- maple-mini-type-b-board-slot1
MARMEX_VB       camera( p5, p6, p7, p22, p26, p28, p27 );
// mosi, miso, sclk, cs, reset, sda, scl    -- maple-mini-type-b-board-slot2
#endif

#ifdef  BASEBOARD_MAPLE_ORIGINAL
MARMEX_OB_oled  oled1( p5, p7,  p8, p30, p11 );
// mosi, sclk, cs, rst, power_control               -- maple-board-slot1
MARMEX_VB       camera( p5, p6, p7, p26, p17, p28, p27 );
// mosi, miso, sclk, cs, reset, sda, scl    -- maple-board-slot2
#endif
//BusOut          led( LED3, LED4 );

//  image size (default image size)
#define CAMERA_WIDTH    MARMEX_VB::QCIF_PIXEL_PER_LINE  //  176 pixels(default size)
#define CAMERA_HEIGHT   MARMEX_VB::QCIF_LINE_PER_FRAME  //  144 lines (default size)

//  screen size
#define OLED_WIDTH      MARMEX_OB_oled::WIDTH           //  128 pixels
#define OLED_HEIGHT     MARMEX_OB_oled::HEIGHT          //  128 lines

//  x/y offset to draw center image of the camera
#define X_OFFSET        ((CAMERA_WIDTH  - OLED_WIDTH ) / 2)
#define Y_OFFSET        ((CAMERA_HEIGHT - OLED_HEIGHT) / 2)

int main()
{
    short   buf[ OLED_WIDTH ];

    oled1.cls();    //  clear OLED screen

    while ( 1 ) {

        camera.open_transfer();     //  pause updating the camera buffer
        
        //  data transfer from camera to OLED (line by line copy)
        //  
        for ( int line = 0; line < OLED_HEIGHT; line++  ) {
            
            //  1 line (128 pixels) data read from camera
            camera.read_a_line( buf, line + Y_OFFSET, X_OFFSET, OLED_WIDTH );
            
            //  1 line (128 pixels) data write into OLED
            oled1.blit565( 0, line, OLED_WIDTH, 1, buf );
        }

        camera.close_transfer();    //  resume updating the camera buffer
    }
}
