/**
 *  @file       FilterTest.h
 *  @brief      Header file for FilterTest.cpp
 *  @date       2015.07.30
 *  @version    1.0.2.1
 */
#ifndef _INC_FilterTest
#define _INC_FilterTest

#include "mbed.h"

/* High pass filter fc = 0.5 Hz, fs = 1000 Hz */
#define INIT_HB (0.998431665916719)    /* HPF numerator coefficient */
#define INIT_HA (-0.996863331833438)   /* HPF denominator coefficient */

/* Low pass filter fc = 30 Hz, fs = 1000 Hz */
#define INIT_LB (0.007820208033497)    /* LPF numerator coefficient */
#define INIT_LA1 (-1.734725768809275)  /* LPF denominator coefficient 1 */
#define INIT_LA2 (0.766006600943264)   /* LPF denominator coefficient 2 */

/* Notch filter fc = 50 Hz, fs = 1000 Hz */
// #define INIT_NB (0.820675769028781)    /* BRF numerator coefficient */
// #define INIT_NA1 (-1.561018075800720)  /* BRF denominator coefficient 1 */
// #define INIT_NA2 (0.641351538057563)   /* BRF denominator coefficient 2 */

// /* Notch filter fc = 60 Hz, fs = 1000 Hz */
#define INIT_NB (0.793459754030595)    /* BRF numerator coefficient */
#define INIT_NA1 (-1.475480443592650)  /* BRF denominator coefficient 1 */
#define INIT_NA2 (0.586919508061190)   /* BRF denominator coefficient 2 */

/**  Filter test
 */
class FilterTest
{

public:
    FilterTest();
    double calc(double val, int hpf_on, int lpf_on, int brf_on);
    bool set_hpf_coef(double hb, double ha);
    bool set_lpf_coef(double lb, double la1, double la2);
    bool set_brf_coef(double nb, double na1, double na2);

private:

    /* Coefficient */
    double      _hb;                /* High pass filter numerator coefficient */
    double      _ha;                /* High pass filter denominator coefficient */
    double      _lb;                /* Low pass filter numerator coefficient */
    double      _la1;               /* Low pass filter denominator coefficient 1 */
    double      _la2;               /* Low pass filter denominator coefficient 2 */
    double      _nb;                /* Notch filter numerator coefficient */
    double      _na1;               /* Notch filter denominator coefficient 1 */
    double      _na2;               /* Notch filter denominator coefficient 2 */

    /* Delay buffer */
    double      _hw;                /* High pass filter delay buffer */
    double      _lw1;               /* Low pass filter delay buffer 1 */
    double      _lw2;               /* Low pass filter delay buffer 2 */
    double      _nw1;               /* Notch filter delay buffer 1 */
    double      _nw2;               /* Notch filter delay buffer 2 */

    /* Member functions */
    void reset_hpf_buf();
    void reset_lpf_buf();
    void reset_brf_buf();
    double hpf(double x);
    double lpf(double x);
    double brf(double x);
};
#endif    /* INC_FilterTest */
