/**
 *  @file       FftTest.h
 *  @brief      Header file for FftTest.cpp
 *  @date       2015.02.24
 *  @version    1.0.2
 */
#ifndef _INC_FftTest
#define _INC_FftTest

// #define _LARGE_RAM   /* Uncomment if using large RAM. */
/* Hann window array and bit reversal array can  */
/* be generated dynamically instead of constant. */

#include "mbed.h"

/* Constant */
#define PI              (3.141592)
#define SQRT_2F         (1.41421356f)
#define DATA_LENGTH     (256)

/**  FFT test
 */
class FftTest
{

public:
    FftTest();
    ~FftTest();
    void apply_window(float in_data[], float out_data[]);
    void calc_fft(float in_data[], float out_re_data[], float out_im_data[]);
    void calc_power(float re_data[], float im_data[], float pow_data[], int32_t dat_len);
    void calc_amplitude(float pow_data[], float amp_data[], int32_t dat_len);
    void norm_amplitude(float amp_data[], int32_t dat_len);

private:
    /* Menber variables */
    int32_t _dat_len;
    int32_t _digit_len;
#ifdef _LARGE_RAM
    float* _window_array;
    int32_t* _br_idx_array;
#else
    static const float _window_array[DATA_LENGTH];  /* Hann window array */
    static const int _br_idx_array[DATA_LENGTH];    /* Bit reversal index array */
#endif  /* LARGE_RAM */

    /* Member functions */
    void init();
    int32_t get_digit_len(int32_t val);
    void set_hann_window();
    void set_bit_reversal();
};
#endif  /* INC_FftTest */
