#include "mbed.h"
#include "ATParser.h"
#include "MPL3115A2.h"
#include <string.h>
#include <stdlib.h>

BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial device(PA_9, PA_10);  // tx, rx
DigitalOut myled(LED1);
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);

//This program will be called when an s is typed
//in screen

//This program will ultimately call itself every hour


int main()
{
    pc.baud(115200);
    device.baud(115200);
    pc.printf("Hola\n\r");
    ATParser at = ATParser(device, "\n\r", 256, 2000, false);
    if(at.send("AT") && at.recv("\n\r"))
    {
        pc.printf("Bueno#1\n\r");
        myled = !myled;
    }
    else
        pc.printf("Nope#1\n\r"); 
    if(at.send("AT+NI=1,MTCDT-19400691") && 1) 
        pc.printf("Bueno#2\n\r");
    else  
       pc.printf("Nope#2\n\r");
    if(at.send("AT+NK=1,MTCDT-19400691") && 1)
        pc.printf("Bueno #3\n\r");
    else
        pc.printf("Nope #3\n\r");
    if(at.send("AT+FSB=1") && 1)
        pc.printf("Bueno #4\n\r");
    else
        pc.printf("Nope #4\n\r");
    if(at.send("AT+JOIN")&& 1)
        pc.printf("Bueno #5\n\r");
    else
        pc.printf("Nope #5\n\r");
    
    char devID[24];
    if(at.send("AT+DI") && at.recv("%s\r\n\r\nOK", &devID))
        pc.printf("Bueno#6\n\r");
    else
        pc.printf("Nope #6\n\r");
    while(1)
    {    
        double pressure = pressure_sensor.getPressure();
        double temperature = pressure_sensor.getTemperature();
        //pc.printf("temp = %lf\n\r", temperature);
        //pc.printf("pressure = %lf\n\r", pressure);
        char temp[5];
        char press[6];
        int n;
        n = sprintf(temp, "%.2lf", temperature);
        n = sprintf(press, "%.2lf", pressure);
        //pc.printf("Transfer worked: %s\n\r", press);
        if(at.send("AT+SEND=\"%s\"", temp) && 1)
            pc.printf("sent temp\n\r");
        else
            pc.printf("didn't send temp #7\n\r");
        if(at.send("AT+SEND=\"%s\"", press) && 1)
            pc.printf("sent pressure\n\r");
        else
            pc.printf("didn't send pressure\n\r");
        wait(3600);
    }
}

/*
Bryce code for getting Device ID
memset(address, 0, 100);
len = at.read(address, 100)
for(i = 0; i < len; i++)
{
    if(!address[i]);
    else if(address[i] >= '0') printf("%c\n\r",address[i]);
    else if(address[i]=='\n') printf("\\n\n\r", address[i]);
    else if(address[i]=='\r') printf("\\r\n\r", address[i]);
}
*/