#include "mbed.h"
#include "ATParser.h"
#include "TSL2561.h"
#include <string.h>
#include <stdlib.h>

BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial device(PA_9, PA_10);  // tx, rx
DigitalOut myled(LED1);
TSL2561 lightsensor(PB_7,PB_6);
LowPowerTicker flipper;
DigitalOut Teddy(D8);
ATParser at = ATParser(device, "\n\r", 256, 2000, false);

int i =0;
char *day[5];


void sendit()
{     
    float lightnum = lightsensor.lux();
    pc.printf("light = %.5f\n\r", lightnum);
    day[i] = new char[8];
    sprintf(day[i], "%f", lightnum);
    i++;
    if (i == 5)
    {
        Teddy = 1;
        int j;
        for(j = 0; j < 5; j++)
        {
            if(at.send("AT+SEND=\"%s\"", day[j]) && 1)
            {    
                pc.printf("success\n\r");
            }
            else
                pc.printf("iserox\n\r");
        }
        Teddy = 0;
        i = 0;
        for(j=0; j < 5; j++)
        {
            free(day[j]);
        }
    }   
}

void connect() 
{
    if(at.send("AT") && at.recv("\n\r"))
        pc.printf("Bueno#1\n\r");
    else
        pc.printf("Nope#1\n\r"); 
    if(at.send("AT+NI=1,MTCDT-19400691") && 1) 
        pc.printf("Bueno#2\n\r");
    else  
       pc.printf("Nope#2\n\r");
    if(at.send("AT+NK=1,MTCDT-19400691") && 1)
        pc.printf("Bueno #3\n\r");
    else
        pc.printf("Nope #3\n\r");
    if(at.send("AT+FSB=1") && 1)
        pc.printf("Bueno #4\n\r");
    else
        pc.printf("Nope #4\n\r");
    if(at.send("AT+JOIN")&& 1)
        pc.printf("Bueno #5\n\r");
    else
      pc.printf("Nope #5\n\r");      
}


int main()
{
    pc.baud(115200);
    device.baud(115200);
    pc.printf("Hola\n\r");
    Teddy = 0;
    connect();
    flipper.attach(&sendit, 10);
    while(1)
    {    
      wait(420);
    }
}
