#include "mbed.h"
#include "MPL3115A2.h"
#include <string.h>
#include <stdlib.h>
 
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
DigitalIn lever(PA_12); //D2 'on' = 1 
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);

//LocalFileSystem local("local");

/*returns max speed given array of altitudes and length*/
double calcspeed(double j, double *altitude)
{
    int i;
    double tmp, maxspeed =0;
    for(i = 1; i < j; i++)
    {
       tmp = (altitude[i] - altitude[i-1]);
       if(tmp > maxspeed)
            maxspeed = tmp;
    }
    return(maxspeed);     
}

/* 
* Writes altitude array to file
void graph(double *alt, int time)
{
    FILE *fp = fopen("speed.txt","w");
    double speeds[time/2];
    int i;
    for(i = 1; i < time/2; i++)
        speeds[i-1] = alt[i]-alt[i-1];
    for(i = 0; i < time/2; i++)
        fprintf(fp, "%lf\n\r", speeds[i]);
    
    fclose(fp);
}
*/ 

/* returns max speed */
void elevator(void)
{
    double alt[100], pressure[100], temp[100];
    double maxspeed;
    int j=0, i;
    printf("Data collection starting\n\r"); 
    while(1)
    {
         pressure[j] = pressure_sensor.getPressure();
         alt[j] = pressure_sensor.getAltitude();
         temp[j] = pressure_sensor.getTemperature();
         myled = !myled;
         j++;
         if(lever == 0)
            break;
    }
    printf("Data collection ended\n\r");
    printf("Time \t Altitude(m) \t Pressure(hPa) \t Temperature(C)\n\r");
    for(i = 0; i < j; i++)
        printf("%d \t %lf \t %lf \t %lf\n\r", i, alt[i], pressure[i], temp[i]);
    maxspeed = calcspeed(j, alt); 
    printf("The max speed was: %lf\n\r", maxspeed);
    //graph(alt, j);        
}
 
int MPL3115A2_reg_print(int start, int length) {
    uint8_t value;  //the array with the register value
 
    if(length == 0)
        length = 45;
    int i = start, end = start + length;     
    if(start > 0x2D || start < 0x00)
        return(-1);
    if(length < 0)
        return(-1);
    if (pressure_sensor.getID()!=0xC4)
        return(-1);
    if (end > 46)
        return(-1);
        
    for( i = start; i <= end; i++) {
        char name[25];
        pressure_sensor.readRegs(i, &value, 8); //read the registers 1 at a time
        switch (i) {
                case 0x00:
                    strcpy(name,"MPL_STATUS");
                    break;
                case 0x01:
                    strcpy(name,"MPL_OUT_P_MSB");
                    break;
                case 0x02:
                    strcpy(name, "MPL_OUT_P_CSB");
                    break;
                case 0x03:
                    strcpy(name,"MPL_OUT_P_LSB");
                    break;
                case 0x04:
                    strcpy(name,"MPL_OUT_T_MSB");
                    break;
                case 0x05:
                    strcpy(name,"MPL_OUT_T_LSB");
                    break;
                case 0x06:
                    strcpy(name,"MPL_DR_STATUS");
                    break;
                case 0x07:
                    strcpy(name,"MPL_OUT_P_DELTA_MSB");
                    break;
                case 0x08:
                    strcpy(name,"MPL_OUT_P_DELTA_CSB");
                    break;
                case 0x09:
                    strcpy(name,"MPL_OUT_P_DELTA_LSB");
                    break;
                case 0x0A:
                    strcpy(name,"MPL_OUT_T_DELTA_MSB");
                    break;
                case 0x0B:
                    strcpy(name,"MPL_OUT_T_DELTA_LSB");
                    break;
                case 0x0C:
                    strcpy(name,"MPL_WHO_AM_I");
                    break;
                case 0x0D:
                    strcpy(name,"MPL_F_STATUS");
                    break;
                case 0x0E:
                    strcpy(name,"MPL_F_DATA");
                    break;
                case 0x0F:
                    strcpy(name,"MPL_F_SETUP");
                    break;
                case 0x10:
                    strcpy(name,"MPL_TIME_DLY");
                    break;
                case 0x11:
                    strcpy(name,"MPL_SYSMOD");
                    break;
                case 0x12:
                    strcpy(name,"MPL_INT_SOURCE");
                    break;
                case 0x13:
                    strcpy(name,"MPL_PT_DATA_CFG");
                    break;
                case 0x14:
                    strcpy(name,"MPL_BAR_IN_MSB");
                    break;
                case 0x15:
                    strcpy(name,"MPL_BAR_IN_LSB");
                    break;
                case 0x16:
                    strcpy(name,"MPL_P_TGT_MSB");
                    break;
                case 0x17:
                    strcpy(name,"MPL_P_TGT_LSB");
                    break;
                case 0x18:
                    strcpy(name,"MPL_T_TGT");
                    break;
                case 0x19:
                    strcpy(name,"MPL_P_WND_MSB");
                    break;
                case 0x1A:
                    strcpy(name,"MPL_P_WND_LSB");
                    break;
                case 0x1B:
                    strcpy(name,"MPL_T_WND");
                    break;
                case 0x1C:
                    strcpy(name,"MPL_P_MIN_MSB");
                    break;
                case 0x1D:
                    strcpy(name,"MPL_P_MIN_CSB");
                    break;
                case 0x1E:
                    strcpy(name,"MPL_P_MIN_LSB");
                    break;
                case 0x1F:
                    strcpy(name,"MPL_T_MIN_MSB");
                    break;
                case 0x20:
                    strcpy(name,"MPL_T_MIN_LSB");
                    break;
                case 0x21:
                    strcpy(name,"MPL_P_MAX_MSB");
                    break;
                case 0x22:
                    strcpy(name,"MPL_P_MAX_CSB");
                    break;
                case 0x23:
                    strcpy(name,"MPL_P_MAX_LSB");
                    break;
                case 0x24:
                    strcpy(name,"MPL_T_MAX_MSB");
                    break;
                case 0x25:
                    strcpy(name,"MPL_T_MAX_LSB");
                    break;
                case 0x26:
                    strcpy(name,"MPL_CTRL_REG1");
                    break;
                case 0x27:
                    strcpy(name,"MPL_CTRL_REG2");
                    break;
                case 0x28:
                    strcpy(name,"MPL_CTRL_REG3");
                    break;
                case 0x29:
                    strcpy(name,"MPL_CTRL_REG4");
                    break;
                case 0x2A:
                    strcpy(name,"MPL_CTRL_REG5");
                    break;
                case 0x2B:
                    strcpy(name,"MPL_OFF_P");
                    break;
                case 0x2C:
                    strcpy(name,"MPL_OFF_T");
                    break;
                case 0x2D:
                    strcpy(name,"MPL_OFF_H");
                    break;
                default:
                    printf("ERR\n\r");
        }    
        printf("0x%02X: %s = 0x%02X\n\r", i, name, value);
        
    }
    return(0);
} 
 
 
int main() {
    int start, length;
    printf("Hola, buenas tardes\n\r");
    printf("Enter start: \n\r");
    scanf("%d", &start);
    printf("Enter length: \n\r");
    scanf("%d", &length);
    MPL3115A2_reg_print(start, length);
    while (1){
        if(lever == 1)
            elevator();
        wait(1);
    }
    //no return; while(1) never exited  
         
} 