#include "mbed.h"
#include "ATParser.h"
#include "TSL2561.h"
#include "MPL3115A2.h"
#include <string>
#include <algorithm>
#include <iostream>




MPL3115A2 pressure_sensor(PB_7, PB_6, 0x60);
BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial dev(PA_9, PA_10);
DigitalOut myled(LED1);
TSL2561 light_sensor(PB_7, PB_6); // addr: 0x29 since addr is groundedx

using namespace std;

bool send_it(float * fArray, ATParser *at);


int main() {
    
    double temp, pres;
    pc.baud(115200);
    dev.baud(115200);
    
    light_sensor.set_timing_reg(0x10); // nominal integration time: 402ms (max in datasheet)
    
    pc.printf("Begin headaches\r\n");
    
    ATParser at = ATParser(dev, "\r\n");
    
    if (at.send("AT") && at.recv("OK"))
        pc.printf("AT Communication Success\r\n");
    
    // Set network name and passphrase
    if (at.send("AT+NI=1,MTCDT-19400691") && at.recv("OK"))
        pc.printf("Network ID specified\r\n");
    if (at.send("AT+NK=1,MTCDT-19400691") && at.recv("OK"))
        pc.printf("Network Passphrase specified\r\n");
    
    if(at.send("AT+FSB=1") && at.recv("OK"))
        pc.printf("band specified\r\n");
    
    bool joined = false;
    while(!joined) {
        if (at.send("AT+JOIN") && at.recv("OK")) {
            pc.printf("Joined Network!\r\n");
            joined = true;
        }
        else {
            pc.printf("network not joined\r\n");
        }
    }
    
    // set big data rate
    if(at.send("AT+TXDR=DR2\r\n") && at.recv("OK"))
        pc.printf("data rate set.\r\n");
    wait(1);
    
    
    char lightBuff[20];
    char sendcommand[5000] = "AT+SEND=";
    float pressureCollections[24];
    float tempCollections[24];
    
    int i = 0;
    while(1) {
        // wait
        wait(3600);
        if(i == 24) {
            send_it(&pressureCollections[0], &at);
            send_it(&tempCollections[0], &at);
            i = 0;
        }
        
        
        //float light_value = light_sensor.lux(); // read light sensor
        temp = pressure_sensor.getTemperature();
        pres = pressure_sensor.getAltitude();
        //pc.printf("temp: %f, press: %f\r\n", temp, pres);
        tempCollections[i] = temp;
        pressureCollections[i++] = pres;
        //pc.printf("%f\n\r", dataCollections[i - 1]);
        
    }
    return(0);
}



bool send_it(float * fArray, ATParser *at) {
    //pc.printf("it worked\r\n");
    
    char send1[100];
    char send2[100];
    
    sprintf(send1, "AT+SEND=%3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f\r\n", fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7], fArray[8], fArray[9], fArray[10], fArray[11]);
    wait(2);
    //pc.printf("%s\r\n", *send1);
    
    sprintf(send2, "AT+SEND=%3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f\r\n", fArray[12], fArray[13], fArray[14], fArray[15], fArray[16], fArray[17], fArray[18], fArray[19], fArray[20], fArray[21], fArray[22], fArray[23]);
    
    //pc.printf("%s\r\n", *send2);
    bool did_it_work = false;
    //wait(2);
    
    
    if ((*at).send(send1) && (*at).recv("OK")) {
        pc.printf("light reading sent!\r\n");
        did_it_work = true;
    }
    else {
        pc.printf("send not successful\r\n");
        did_it_work = false;
    }
    //////////////send2////////////////////
    
    if ((*at).send(send2) && (*at).recv("OK")) {
        pc.printf("light reading sent!\r\n");
        return did_it_work && true;
    }
    else {
        pc.printf("send not successful\r\n");
        return false;
    }
}
 