#include "mbed.h"
#include <iostream>
#include <fstream>
#include "MPL3115A2.h"



Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
DigitalIn startStop(PA_4);
//Selects SDA as I2C1_SDA on pin PB_7
//Selects SCL on I2C1_SCL on pin PB_6
//the I2c address of the pressure sensor is fixed at 0x60
MPL3115A2 pressure_sensor(PB_7, PB_6, 0x60);
using namespace std;

int mpl3115_reg_print(int start, int length);
void register_map_mpl3115A2(int i, int value);
int collect_data();


#define ARRAY_SIZE 5000
double *pressure_arr = (double *)malloc(sizeof(double) * ARRAY_SIZE);
double *temp_arr = (double *)malloc(sizeof(double) * ARRAY_SIZE);
double *pressPtr = pressure_arr;
double *tempPtr = temp_arr;
int buffer_full = 0;



int main() {
    printf("\n\rMPL3115A2 test\n\r");
    mpl3115_reg_print(0x26, 1);
    
    /* set bit 7 to one for altimeter mode && set bits 3,4,5 
    0xA9 for 1
    to 0b101 130 ms, 0b100 for 66 ms if 130 is too slow (e.g. 0xA1) */
    pressure_sensor.setCTRL_REG1( 0xA1 ); 
    
    while(1) {
        // don't overflow buffer
        if(buffer_full >= ARRAY_SIZE) {
            printf("\n\n\tBuffer Full. Ending program.\n\n\r");
            return(0);
        }
            /*int offset = 0;
            for (int i = 0; i < buffer_full; i++) {
                *(pressure_arr + offset) = 0;
                *(temp_arr + offset) = 0;
                offset += sizeof(double);
            }*/
            
        //printf("nooooope\n\r");
        if(!startStop.read()) {
            printf("GPIO Connectedn\r");
            collect_data();
            printf("done collecting\n\rarray size: %d,\t buffer fill: %d\n\r", ARRAY_SIZE, buffer_full);
            int offset = 0;
            for(int i = 0; i < buffer_full; i++)
            {
                printf("\t%d\t%lf\t%lf\n\r", i,*(pressure_arr + offset), *(temp_arr + offset));
                offset += sizeof(double);
            }
        }       
    }
    
   
    /*printf("start\r\n");
    mpl3115_reg_print(38, 5);
    printf("finish\r\n");
    return(0);*/
    
}
//void MPL3115A2::readRegs(int addr, uint8_t * data, int len)
int mpl3115_reg_print(int start, int length) {

  if(pressure_sensor.getID() != 0xC4) { 
    printf("chip is not connected\r\n");
    return -1;
  }
  printf("0xC4! Welcome, user.\r\n");
  
  wait_ms(500);

  int l = 0;
  l = (length == 0? 45: length); //if length is 0 make l= 46

  // check input range: [0x00, 0x2E] 0,46 && confirm length >= 0
  if(start < 0 || l > 45 || l < 0) {
    printf("illegal input exception\r\n");
    return -1;
  }

    uint8_t data[1];
    
      // print reg, name, val
  for(int i = start; i < (start + l); i++) {
    // reading (1 byte its bit oriented)8-bits from each register
    pressure_sensor.readRegs(i, data, 1); 
    //printf("0x%x\tregister: 0x%.2x\r\n", i, data[0]);
    register_map_mpl3115A2(i, data[0]);
  }
  
  //printf("Reg Address %d: Register Name = %s", address, name)
  return 0;
}







void register_map_mpl3115A2(int i, int value) {
  //char* regi;
  switch(i) {
  case 0x00:
    //    *regi = 'STATUS';
    printf("%x:\tSTATUS 0x%.2x\r\n",i,value);
    break;
  case 0x01:
    //    *regi = "OUT P_MSB";
    printf("%x:\tOUT P_MSB 0x%.2x\r\n",i, value);
    break;
  case 0x02:
    //    *regi = "OUT_P_CSB";
    printf("%x:\tOUT_P_CSB= 0x%.2x\r\n",i, value);
    break;
  case 0x03:
    //    *regi = "OUT_P_LSB";
    printf("%x:\tOUT_P_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x04:
    //    *regi = "OUT_T_MSB";
    printf("%x:\tOUT_T_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x05:
    //    *regi = "OUT_T_LSB";
    printf("%x:\tOUT_T_LSB= 0x%.2x\r\n",i, value);
    break;    
  case 0x06:
    //    *regi = "DR_STATUS";
    printf("%x:\tDR_STATUS= 0x%.2x\r\n",i, value);
    break;
  case 0x07:
    //    *regi = "OUT_P_DELTA_MSB";
    printf("%x:\tOUT_P_DELTA_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x08:
    //    *regi = "OUT_P_DELTA_CSB";
    printf("%x:\tOUT_P_DELTA_CSB= 0x%.2x\r\n",i, value);
    break;
  case 0x09:
    //    *regi = "OUT_P_DELTA_LSB";
    printf("%x:\tOUT_P_DELTA_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x0A:
    //    *regi = "OUT_T_DELTA_MSB";
    printf("%x:\tOUT_T_DELTA_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x0B:
    //    *regi = "OUT_T_DELTA_LSB";
    printf("%x:\tOUT_T_DELTA_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x0C:
    //    *regi = "WHO_AM_I";
    printf("%x:\tWHO_AM_I= 0x%.2x\r\n",i, value);
    break;
  case 0x0D:
    //    *regi = "F_STATUS";
    printf("%x:\tF_STATUS= 0x%.2x\r\n",i, value);
    break;
  case 0x0E:
    //    *regi = "F_DATA";
    printf("%x:\tF_DATA= 0x%.2x\r\n",i, value);
    break;
  case 0x0F:
    //    *regi = "F_SETUP";
    printf("%x:\tOUT_T_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x10:
    //    *regi = "TIME_DLY";
    printf("%x:\tTIME_DLY= 0x%.2x\r\n",i, value);
    break;
  case 0x11:
    //    *regi = "SYSMOD";
    printf("%x:\tSYSMOD= 0x%.2x\r\n",i, value);
    break;
  case 0x12:
    //    *regi = "INT_SOURCE";
    printf("%x:\tINT_SOURCE= 0x%.2x\r\n",i, value);
    break;
  case 0x13:
    //    *regi = "PT_DATA_CFG";
    printf("%x:\tPT_DATA_CFG= 0x%.2x\r\n",i, value);
    break;
  case 0x14:
    //    *regi = "BAR_IN_MSB";
    printf("%x:\tBAR_IN_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x15:
    //    *regi = "BAR_IN_LSB";
    printf("%x:\tBAR_IN_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x16:
    //    *regi = "P_TGT_MSB";
    printf("%x:\tP_TGT_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x17:
    //    *regi = "P_TGT_LSB";
    printf("%x:\tP_TGT_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x18:
    //    *regi = "T_TGT";
    printf("%x:\tT_TGT= 0x%.2x\r\n",i, value);
    break;
  case 0x19:
    //    *regi = "P_WND_MSB";
    printf("%x:\tOUT_T_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x1A:
    //    *regi = "P_WND_LSB";
    printf("%x:\tP_WND_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x1B:
    //    *regi = "T_WND";
    printf("%x:\tT_WND= 0x%.2x\r\n",i, value);
    break;
  case 0x1C:
    //    *regi = "P_MIN_MSB";
    printf("%x:\tP_MIN_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x1D:
    //    *regi = "P_MIN_CSB";
    printf("%x:\tP_MIN_CSB= 0x%.2x\r\n",i, value);
    break;
  case 0x1E:
    //    *regi = "P_MIN_LSB";
    printf("%x:\tP_MIN_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x1F:
    //    *regi = "T_MIN_MSB";
    printf("%x:\tT_MIN_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x20:
    //    *regi = "T_MIN_LSB";
    printf("%x:\tT_MIN_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x21:
    //    *regi = "P_MAX_MSB";
    printf("%x:\tP_MAX_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x22:
    //    *regi = "P_MAX_CSB";
    printf("%x:\tP_MAX_CSB= 0x%.2x\r\n",i, value);
    break;
  case 0x23:
    //    *regi = "P_MAX_LSB";
    printf("%x:\tP_MAX_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x24:
    //    *regi = "T_MAX_MSB";
    printf("%x:\tT_MAX_MSB= 0x%.2x\r\n",i, value);
    break;
  case 0x25:
    //    *regi = "T_MAX_LSB";
    printf("%x:\tT_MAX_LSB= 0x%.2x\r\n",i, value);
    break;
  case 0x26:
    //    *regi = "CTRL_REG1";
    printf("%x:\tCTRL_REG1= 0x%.2x\r\n",i, value);
    break;
  case 0x27:
    //    *regi = "CTRL_REG2";
    printf("%x:\tCTRL_REG2= 0x%.2x\r\n",i, value);
    break;
  case 0x28:
    //    *regi = "CTRL_REG3";
    printf("%x:\tCTRL_REG3= 0x%.2x\r\n",i, value);
    break;
  case 0x29:
    //    *regi = "CTRL_REG4";
    printf("%x:\tCTRL_REG4= 0x%.2x\r\n",i, value);
    break;
  case 0x2A:
    //    *regi = "CTRL_REG5";
    printf("%x:\tCTRL_REG5= 0x%.2x\r\n",i, value);
    break;
  case 0x2B:
    //    *regi = "OFF_P";
    printf("%x:\tOFF_P= 0x%.2x\r\n",i, value);
    break;
  case 0x2C:
    //    *regi = "OFF_T";
    printf("%x:\tOFF_T= 0x%.2x\r\n",i, value);
    break;
  case 0x2D:
    //    *regi = "OFF_H";
    printf("%x:\tOFF_H= 0x%.2x\r\n",i, value);
    break;
    }
}

int collect_data() {
        int counter = 0;
        // while GPIO is 1
        while(!startStop.read()) {
            // read temp and pressure data
            *tempPtr = pressure_sensor.getTemperature();
            *pressPtr = pressure_sensor.getPressure();
            wait_ms(100); // wait 100 ms makes sampling rate 10Hz
            //increment pointers
            tempPtr = tempPtr + sizeof(double);
            pressPtr = pressPtr + sizeof(double);
            buffer_full++;
            counter++;
            if(counter % 10 == 0) {
                myled = !myled;    
            }
        }
        
        *tempPtr = -23.232323; // values that will indicate a sample is complete
        *pressPtr = -23.2323;
        tempPtr = tempPtr + sizeof(double);
        pressPtr = pressPtr + sizeof(double);
        buffer_full++;
        myled = 0;
        return 0;
        
}

