/* 
 * ENGR E 210 - CYBER PHYSICAL SYSTEMS (DIGITAL SYSTEMS)
 * LAB 7 - ELEVATOR ALTIMETER
 * CODE BY KRISH HEMANT MHATRE AND ETHAN ZHANG
 */

#include "mbed.h"
#include "MPL3115A2.h"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);

// Selects SDA as I2C1_SDA on pin PB_7
// Selects SCL on I2C1_SCL on pin PB_6
// The I2C address of the pressure sensor is fixed at 0x60. 
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
int mpl3115_reg_print(int start, int length);

int main() {
    uint8_t id;
    pc.printf("\n\r*** MPL3115A2 Pressure/Temperature Sensor Test *** \n\r");
    while ((id=pressure_sensor.getID())!=0xC4) {
        pc.printf("Status read unsuccessful: Value = 0x%02x\n\r",id);
        pc.printf("Check wiring to the pressure sensor\n\r",id);
        pc.printf("Retesting for correct ID in 1 second...\n\r");
        wait(1);
    }
    pc.printf("Status read successfully: Value = 0x%02x\n\r",id);
    pc.printf("***1hz readings from the pressure sensor***\n\r");
    while(1) 
    {
        float distanceA = pressure_sensor.getAltitude();
        wait(1);
        myled = 1;
        float distanceB = pressure_sensor.getAltitude();
        float velocity;
        if(distanceA>distanceB)
        {
           velocity = distanceA-distanceB;
        }
        else
        {
           velocity = distanceB-distanceA;
        }
        pc.printf("Velocity = %f m/s\n\r", velocity);
        pc.printf("TEMPERATURE = %2.2f C     PRESSURE = %2.2f hPa\n\r", pressure_sensor.getTemperature(), pressure_sensor.getPressure());
        myled = 0;
        wait(1);
    }
    
    
    //int I = mpl3115_reg_print(0, 50);
}


int mpl3115_reg_print(int start, int length) {
    int return_value = 0;
    char *text = "                                  ";
    uint8_t value;
    int address;
    if(start < 0x00 || start > 0x2E)
    {
        return_value = -1;  
        exit(0); 
    } 
    else
    {
    int i = start;
    for(i = start; i < length; i++) 
    {
        address = i;
        if(i == 0)
        {
            text = "STATUS";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 1)
        {
            text = "OUT_P_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 2)
        {
            text = "OUT_P_CSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 3)
        {
            text = "OUT_P_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 4)
        {
            text = "OUT_T_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 5)
        {
            text = "OUT_T_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 6)
        {
            text = "DR_STATUS";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 7)
        {
            text = "OUT_P_DELTA_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 8)
        {
            text = "OUT_P_DELTA_CSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 9)
        {
            text = "OUT_P_DELTA_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 10)
        {
            text = "OUT_T_DLETA_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 11)
        {
            text = "OUT_T_DELTA_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 12)
        {
            text = "WHO_AM_I";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 13)
        {
            text = "F_STATUS";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 14)
        {
            text = "F_DATA";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 15)
        {
            text = "F_SETUP";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 16)
        {
            text = "TIME_DLY";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 17)
        {
            text = "SYSMOD";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 18)
        {
            text = "INT_SOURCE";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 19)
        {
            text = "PT_DATA_CFG";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 20)
        {
            text = "BAR_IN_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 21)
        {
            text = "BAR_IN_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 22)
        {
            text = "P_TGT_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 23)
        {
            text = "P_TGT_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 24)
        {
            text = "T_TGT";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 25)
        {
            text = "P_WND_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 26)
        {
            text = "P_WND_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 27)
        {
            text = "T_WND";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 28)
        {
            text = "P_MIN_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 29)
        {
            text = "P_MIN_CSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 30)
        {
            text = "P_MIN_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 31)
        {
            text = "T_MIN_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 32)
        {
            text = "T_MIN_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 33)
        {
            text = "P_MAX_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 34)
        {
            text = "P_MAX_CSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 35)
        {
            text = "P_MAX_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 36)
        {
            text = "T_MAX_MSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 37)
        {
            text = "T_MAX_LSB";   
            pressure_sensor.readRegs(address, &value, 8);
        }
       else if(i == 38)
        {
            text = "CTRL_REG1";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 39)
        {
            text = "CTRL_REG2";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 40)
        {
            text = "CTRL_REG3";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 41)
        {
            text = "CTRL_REG4";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 42)
        {
            text = "CTRL_REG5";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 43)
        {
            text = "OFF_P";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 44)
        {
            text = "OFF_T";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else if(i == 45)
        {
            text = "OFF_H";   
            pressure_sensor.readRegs(address, &value, 8);
        }
        else
        {
            text = "NULL";
            value = NULL;
            
        }
        
        if(i <= 46 && text != "NULL")
        {
           printf("0x%2.2hhX: %s=0x%2.2hhX \n\r", address, text, value);
        }
    }
 }   
    return return_value;
}

