/* 
 * ENGR E 210 - CYBER PHYSICAL SYSTEMS (DIGITAL SYSTEMS)
 * LAB 6 - VIBRATION DETECTOR
 * CODE BY KRISH HEMANT MHATRE AND ETHAN ZHANG
 */

#include "mbed.h"
#include "ADXL362.h"
 
// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);
DigitalOut led1(LED1);
int adxl362_reg_print(int start, int length);

int main() {
    adxl362.reset();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    int i = adxl362_reg_print(0, 50);
    
   /* int8_t x,y,z; 
    int knock = -2;
    led1 = 0;
     while(1) 
    {
        if(!led1)
        {
           int a = x+y+z;
           x=adxl362.scanx_u8();
           y=adxl362.scany_u8();
           z=adxl362.scanz_u8();
           int b = x+y+z;
           printf("x = %d y = %d z = %d\r\n",x,y,z);
           if(a-b > 2 || b-a > 2)
           {
              knock++;
              led1 = 1;
           }
           printf("knocks = %d\r\n", knock);
           wait_ms(400);
        }
        else
        {
           wait(2);
           led1 = 0;    
        }
    }*/
    
}



int adxl362_reg_print(int start, int length)
{
    int return_value = 0;
    char *text;
    int value, address;
    if(start < 0x00 || start > 0x2E)
    {
        return_value = -1;  
        exit(0); 
    } 
    else
    {
    int i = start;
    for(i = start; i < length; i++) 
    {
        address = ADXL362::ADXL362_register_t(i);
        if(i == 0)
        {
            text = "DEVID_AD";   
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 1)
        {
            text = "DEVID_MST";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 2)
        {
            text = "PARTID";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 3)
        {
            text = "REVID";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 8)
        {
            text = "XDATA";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 9)
        {
            text = "YDATA";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 10)
        {
            text = "ZDATA";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 11)
        {
            text = "STATUS";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 12)
        {
            text = "FIFO_ENTRIES_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 13)
        {
            text = "FIFO_ENTRIES_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 14)
        {
            text = "XDATA_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 15)
        {
            text = "XDATA_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 16)
        {
            text = "YDATA_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 17)
        {
            text = "YDATA_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 18)
        {
            text = "ZDATA_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 19)
        {
            text = "ZDATA_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 20)
        {
            text = "TEMP_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 21)
        {
            text = "TEMP_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 31)
        {
            text = "SOFT_RESET";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 32)
        {
            text = "THRESH_ACT_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 33)
        {
            text = "THRESH_ACT_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 34)
        {
            text = "TIME_ACT";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 35)
        {
            text = "THREST_INACT_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 36)
        {
            text = "THRESH_INACT_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 37)
        {
            text = "TIME_INACT_L";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 38)
        {
            text = "TIME_INACT_H";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 39)
        {
            text = "ACT_INACT_CTL";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 40)
        {
            text = "FIFO_CONTROL";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 41)
        {
            text = "FIFO_SAMPLES";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 42)
        {
            text = "INTMAP1";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 43)
        {
            text = "INTMAP2";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 44)
        {
            text = "FILTER_CTL";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 45)
        {
            text = "POWER_CTL";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else if(i == 46)
        {
            text = "SELF_TEXT";
            value = (adxl362.read_reg((ADXL362::ADXL362_register_t(i))));
        }
        else
        {
            text = "NULL";
            value = NULL;
        }
        if(i <= 46 && text != "NULL")
        {
           printf("0x%2.2hhX: %s=0x%2.2hhX \n\r", address, text, value);
        }
    }
    }
    
    return return_value;
}
