
/* 
 * ENGR E 210 - CYBER PHYSICAL SYSTEMS (DIGITAL SYSTEMS)
 * LAB 3 - ANALOG FILTERS AND OSCILLOSCOPE
 * CODE BY KRISH HEMANT MHATRE AND ETHAN ZHANG
 */
#include "mbed.h"
#include <string.h>

#if !DEVICE_ANALOGOUT
#error You cannot use this example as the AnalogOut is not supported on this device.
#else
AnalogOut my_output(PA_4);
#endif

#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

// Configuration for sinewave output
#define BUFFER_SIZE (360)
uint16_t buffer[BUFFER_SIZE];

Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalIn button(PC_13);

void Led(int a)
{
    led1 = a;
}

void Blink(int n)
{
    int i = 0;
    for(i=0; i<n; i++)
    {
        led1 = 1;
        wait(0.5);
        led1= 0;
        wait(0.5);
    }
}


void Button()
{
    if(button.read() == 1)
    {
        pc.printf("RELEASED\n\r");
    }
    else
    {
        pc.printf("PRESSED\n\r");
    }
}

void calculate_sinewave(float amp){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     buffer[i] = (uint16_t)(amp * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}

int main() 
{
    pc.printf("Nucleo is running\n\r");
    pc.printf("cps%\n\r");
    int size = 32;
    char str[size];
    int i = 0;
    while(1)
    {
        str[i] = pc.getc();
        pc.putc(str[i]);
        
        if (i >= size)
        {
            pc.printf("OVER BUFFER\n\r");
            i = 0;
            for(int j = 0; j < size; j++)
            {
                str[j] = 0;
            }
            pc.printf("cps%\n\r");
        }
        if(str[i] == 13)
        {
            pc.printf("\n\rOK\n\r");
            str[i] = '\0';
            pc.printf("Command Recieved: %s\n\r", str);
            char s[5];
            sscanf(str, "%s", s);
            if(strcmp(str, "BUTTON") == 0)
            {
                Button();
                pc.printf("Button checked.\n\r");
            }
            else if(strcmp("LED ON", str) == 0)
            {
                Led(1);
                pc.printf("LED is on\n\r");
            }
            else if(strcmp("LED OFF", str) == 0)
            {
                Led(0);
                pc.printf("LED is off\n\r");
            }
            else if(strcmp(s, "BLINK") == 0)
            {
                pc.printf("Reading a blink\n\r");
                char *a = strtok(str, " ");
                a = strtok(NULL, " ");
                pc.printf("Start blink\n\r");
                int n;
                sscanf(a, " %d", &n);
                if(n>=1 && n<=10)
                {
                   Blink(n);
                   pc.printf("Blink complete\n\r");
                }
                else
                {
                    pc.printf("ERROR: Blink cycle should be between 1 and 10\n\r");
                }
            }
            else if(strncmp(str, "DC", 2) == 0)
            {
                   pc.printf("Reading DC\n\r");
                   char *s1 = strtok(str, " ");
                   s1 = strtok(NULL, " ");
                   float volt;
                   sscanf(s1, " %f", &volt);
                   
                   if((volt < (float)0.5) || (volt > (float)3.0))
                   {
                       pc.printf("Voltage out of range\n\r");    
                   }
                   else 
                   {  
                       float adjust = 19720;
                       
                       pc.printf("Voltage is %f\n\r", volt);
                       my_output.write_u16(volt*adjust);
                       pc.printf("Voltage changed\n\r");
                   }
            }
            else if(strncmp(str, "SINE", 4) == 0)
            {
                   float x, amp, freq;
                   char tmp[5];

                   sscanf(str, "%s %f %f\n", tmp, &amp, &freq);
                   pc.printf("Reading data\n\r");
                   if((amp < (float)0.5) || (amp > (float)3.0) || (freq < (float)100) || (freq > (float)500))
                   {
                       pc.printf("Data out of range\n\r");    
                   }
                   else 
                   {  
                       pc.printf("Generating sine wave of amplitude %fV and frequency %fHz\n\r", amp, freq);
                       x = (float)((float)amp/(float)3.3); //3.3V is the given voltage
                       calculate_sinewave(x);
                       while(1) 
                       {      
                          for (int i = 0; i < BUFFER_SIZE; i++) 
                          {
                             my_output.write_u16(buffer[i]);
                             float delay;
                             if(freq <= 200)
                             {
                                delay = (float)((float)((float)4000-(float)((float)5*freq))/(float)(freq*(float)(PI/2)));
                             }
                             else
                             {
                                delay = (float)((float)((float)5000-(float)((float)12*(float)freq))/(float)(freq));   
                             }
                             delay = ((float)(delay/1000000)); //converting microseconds to seconds
                             wait(delay);
                          }
                       }
                   }
            }
            else
            {
                pc.printf("ERR\n\r");
            }
            i = 0;
            for(int j = 0; j < size; j++)
            {
                str[j] = '\0';
            }
            pc.printf("cps%\n\r");
        }
        i++;
    }
}


