#include "mbed.h"
#include "MPL3115A2.h"
#include <string.h>
#include <math.h>
#include <ATParser.h>
#include "BufferedSerial.h"
#include "TSL2561.h"

 
//Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
DigitalOut powerpin(PA_8); // GPIO pin
BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial device(PA_9, PA_10);
 
// Selects SDA as I2C1_SDA on pin PB_7
// Selects SCL on I2C1_SCL on pin PB_6
// The I2C address of the pressure sensor is fixed at 0x60. 
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
TSL2561 lightsensor(PB_4,PA_7);

 
int main() {
    uint8_t id;
    double p, t, l;
    myled = 0;
    powerpin = 0;
    char s[6];
    ATParser at = ATParser(device, "\r\n", 256, 2000, false);
    char buffer[200];
    char buffer1[30];
    pc.baud(115200);
    device.baud(115200);
    
    pc.printf("Hello");
    
    at.send("AT+NI=1,MTCDT-19400691\n\r") && at.recv("OK");
    at.send("AT+NK=1,MTCDT-19400691\n\r") && at.recv("OK");
    at.send("AT+FSB=1\n\r") && at.recv("OK");
    at.send("AT+JOIN\n\r") && at.recv("OK");
    at.send("AT+TXDR=7\n\r") && at.recv("OK");
    
    
    
    while ((id=pressure_sensor.getID())!=0xC4)// wait for the sensor to connect
    {
        wait(1);
    }
    
    strcpy(buffer, "AT+SEND=");
       
    while(1) 
    {
        for(int i = 0; i< 24; i++)
        {     
            l=lightsensor.lux(); 
            sprintf(s, "%.1f", l);
            strcat(buffer, s);
            strcat(buffer, ",");
            pc.printf(buffer);
            pc.printf("\n\r");
            wait(5);
        }
        
            
        
         
     //   p=pressure_sensor.getPressure();
     //   t=pressure_sensor.getTemperature();
       // sprintf(buffer1, "AT+SEND=a\n\r");
     //   sprintf(buffer, "AT+SEND=%.1f,%.1f\n\r", p, t);
    //    pc.printf(buffer);
        at.send(buffer) && at.recv("OK"); 
     //   at.send(buffer1) && at.recv("OK"); 
        wait(10);
    }
}