#include "mbed.h"
#include "MPL3115A2.h"
#include <string>
#include <math.h>
#include <ATParser.h>
#include "BufferedSerial.h"

//Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
DigitalOut powerpin(PA_8); // GPIO pin
BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial device(PA_9, PA_10);

// Selects SDA as I2C1_SDA on pin PB_7
// Selects SCL on I2C1_SCL on pin PB_6
// The I2C address of the pressure sensor is fixed at 0x60. 
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
void mpl3115_reg_print(int start, int length); // prototype

int main() {
    int8_t a;
    uint8_t id;
    double p, t;
    double v , s;
    int cnt = 0;
    myled = 0;
    char c;
    powerpin = 0;
    ATParser at = ATParser(device, "\r\n", 256, 2000, false);
    char buffer[100];
    pc.baud(115200);
    device.baud(115200);
    double alt1 = pressure_sensor.getAltitude(), alt2; // initial alt
    
    mpl3115_reg_print( 0, 0);
    
    while ((id=pressure_sensor.getID())!=0xC4)// wait for the sensor to connect
    {
        wait(1);
    }
    
    while(1)
    {
        if(pc.getc() == 's') // if the GPIO pin is pulled high
        {
            myled != myled;
            //turn on and off led at 1Hz
            p=pressure_sensor.getPressure();
            t=pressure_sensor.getTemperature();
            at.send("Hello");
        }
        else
        {
            myled = 0; // so we know when no data is being taken
        }
    }
}

void mpl3115_reg_print(int start, int length)
{
    uint8_t i, id;
    std::string name;
    uint8_t temp[1];
    id = pressure_sensor.getID();
    
    // check start registers
    if(start >= 0x00 && start <= 0x2D && length >= 0x00 && id == 0xC4)
    {
        // print all if length = 0
        if(length == 0)
        {
            start = 0;
            length = 46;
        }
    
        for(i = start; i < start + length; i++)
        {
            // make sure name is correct
            switch(i)
            {
                case 0x00:
                    name = "MPL_STATUS";
                    break;
                case 0x01:
                    name = "MPL_OUT_P_MSB";
                    break;
                case 0x02:
                    name = "MPL_OUT_P_CSB";
                    break;
                case 0x03:
                    name = "MPL_OUT_P_LSB";
                    break;
                case 0x04:
                    name = "MPL_OUT_T_MSB";
                    break;
                case 0x05:
                    name = "MPL_OUT_T_LSB";
                    break;
                case 0x06:
                    name = "MPL_DR_STATUS";
                    break;
                case 0x07:
                    name = "MPL_OUT_P_DELTA_MSB";
                    break;
                case 0x08:
                    name = "MPL_OUT_P_DELTA_CSB";
                    break;
                case 0x09:
                    name = "MPL_OUT_P_DELTA_LSB";
                    break;
                case 0x0A:
                    name = "MPL_OUT_T_DELTA_MSB";
                    break;
                case 0x0B:
                    name = "MPL_OUT_T_DELTA_LSB";
                    break;
                case 0x0C:
                    name = "MPL_WHO_AM_I";
                    break;
                case 0x0D:
                    name = "MPL_F_STATUS";
                    break;
                case 0x0E:
                    name = "MPL_F_DATA";
                    break;
                case 0x0F:
                    name = "MPL_F_SETUP";
                    break;
                case 0x10:
                    name = "MPL_TIME_DLY";
                    break;
                case 0x11:
                    name = "MPL_SYSMOD";
                    break;
                case 0x12:
                    name = "MPL_INT_SOURCE";
                    break;
                case 0x13:
                    name = "MPL_PT_DATA_CFG";
                    break;
                case 0x14:
                    name = "MPL_BAR_IN_MSB";
                    break;
                case 0x15:
                    name = "MPL_BAR_IN_LSB";
                    break;
                case 0x16:
                    name = "MPL_P_TGT_MSB";
                    break;
                case 0x17:
                    name = "MPL_P_TGT_LSB";
                    break;
                case 0x18:
                    name = "MPL_T_TGT";
                    break;
                case 0x19:
                    name = "MPL_P_WND_MSB";
                    break;
                case 0x1A:
                    name = "MPL_P_WND_LSB";
                    break;
                case 0x1B:
                    name = "MPL_T_WND";
                    break;
                case 0x1C:
                    name = "MPL_P_MIN_MSB";
                    break;
                case 0x1D:
                    name = "MPL_P_MIN_CSB";
                    break;
                case 0x1E:
                    name = "MPL_P_MIN_LSB";
                    break;
                case 0x1F:
                    name = "MPL_T_MIN_MSB";
                    break;
                case 0x20:
                    name = "MPL_T_MIN_LSB";
                    break;
                case 0x21:
                    name = "MPL_P_MAX_MSB";
                    break;
                case 0x22:
                    name = "MPL_P_MAX_CSB";
                    break;
                case 0x23:
                    name = "MPL_P_MAX_LSB";
                    break;
                case 0x24:
                    name = "MPL_T_MAX_MSB";
                    break;
                case 0x25:
                    name = "MPL_T_MAX_LSB";
                    break;
                case 0x26:
                    name = "MPL_CTRL_REG1";
                    break;
                case 0x27:
                    name = "MPL_CTRL_REG2";
                    break;
                case 0x28:
                    name = "MPL_CTRL_REG3";
                    break;
                case 0x29:
                    name = "MPL_CTRL_REG4";
                    break;
                case 0x2A:
                    name = "MPL_CTRL_REG5";
                    break;
                case 0x2B:
                    name = "MPL_OFF_P";
                    break;
                case 0x2C:
                    name = "MPL_OFF_T";
                    break;
                case 0x2D:
                    name = "MPL_OFF_h";
                    break;
            }
            // boy I do love switch statments
            pressure_sensor.readRegs(i, temp, 1);
            pc.printf("0x%x: %s=0x%x\n\r", i, name, temp[0]);
            // actually print the contents of the register
        }
        
    }   
}