#include "mbed.h"
#include "ADXL362.h"
#include <string>
#include <stdlib.h>
 
// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 ADXL362(PA_0,PA_7,PA_6,PA_1);
Serial pc(USBTX, USBRX);
DigitalOut myled(LED3);

int ADXL362_reg_print(int start, int length);
void ADXL362_knock_detect();

int main()
{
    ADXL362.reset();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    ADXL362.set_mode(ADXL362::MEASUREMENT);
    //ADXL362_knock_detect();
    ADXL362_reg_print(0, 0);
}

void ADXL362_knock_detect()
{
    int8_t x1,y1,z1,x2,y2,z2,x,y,z;
    int i = 0;
    while(1)
    {
        
        while(1) 
        {
            x1=ADXL362.scanx_u8();
            y1=ADXL362.scany_u8();
            z1=ADXL362.scanz_u8();
            wait_ms(10);
            x2=ADXL362.scanx_u8();
            y2=ADXL362.scany_u8();
            z2=ADXL362.scanz_u8();
            
            x=abs(x1 - x2);
            y=abs(y1 - y2);
            z=abs(z1 - z2);
            
            if (x>7 || y>7 || z>20)
            break;
     
            //printf("x = %d y = %d z = %d\r\n",x,y,z);
            //pc.printf("x = %d, y = %d, z = %d\r\n", x1, y1, z1);
            wait_ms(10);
        }
        
        myled = 1;
        wait(2);
        myled = 0;
        i++;
        pc.printf("%d\r\n", i);
        
     }
}

int ADXL362_reg_print(int start, int length)
{
    uint8_t i;
    std::string name;
    ADXL362::ADXL362_register_t reg;
    if(start >= 0x00 && start <= 0x2E && length >= 0x00 && (ADXL362.read_reg(ADXL362.DEVID_AD) == 0xAD))
    {
        if(length == 0)
        {
            start = 0;
            length = 47;   
        }
        
        for(i = start; i < start + length; i++)
        {
            switch(i)
            {
                case 0x00:
                    name = "DEVID_AD";
                    reg = ADXL362.DEVID_AD;
                    break;
                case 0x01:
                    name = "DEVID_MST";
                    reg = ADXL362.DEVID_MST;
                    break;
                case 0x02:
                    name = "PARTID";
                    reg = ADXL362.PARTID;
                    break;
                case 0x03:
                    name = "REVID";
                    reg = ADXL362.REVID;
                    break;
                case 0x08:
                    name = "XDATA";
                    reg = ADXL362.XDATA;
                    break;
                case 0x09:
                    name = "YDATA";
                    reg = ADXL362.YDATA;
                    break;
                case 0x0A:
                    name = "ZDATA";
                    reg = ADXL362.ZDATA;
                    break;
                case 0x0B:
                    name = "STATUS";
                    reg = ADXL362.STATUS;
                    break;
                case 0x0C:
                    name = "FIFO_ENTRIES_L";
                    reg = ADXL362.FIFO_ENTRIES_L;
                    break;
                case 0x0D:
                    name = "FIFO_ENTRIES_H";
                    reg = ADXL362.FIFO_ENTRIES_H;
                    break;
                case 0x0E:
                    name = "XDATA_L";
                    reg = ADXL362.XDATA_L;
                    break;
                case 0x0F:
                    name = "XDATA_H";
                    reg = ADXL362.XDATA_H;
                    break;
                case 0x10:
                    name = "YDATA_L";
                    reg = ADXL362.YDATA_L;
                    break;
                case 0x11:
                    name = "YDATA_H";
                    reg = ADXL362.YDATA_H;
                    break;
                case 0x12:
                    name = "ZDATA_L";
                    reg = ADXL362.ZDATA_L;
                    break;
                case 0x13:
                    name = "ZDATA_H";
                    reg = ADXL362.ZDATA_H;
                    break;
                case 0x14:
                    name = "TEMP_L";
                    reg = ADXL362.TEMP_L;
                    break;
                case 0x15:
                    name = "TEMP_H";
                    reg = ADXL362.TEMP_H;
                    break;
                case 0x1F:
                    name = "SOFT_RESET";
                    reg = ADXL362.SOFT_RESET;
                    break;
                case 0x20:
                    name = "THRESH_ACT_L";
                    reg = ADXL362.THRESH_ACT_L;
                    break;
                case 0x21:
                    name = "THRESH_ACT_H";
                    reg = ADXL362.THRESH_ACT_H;
                    break;
                case 0x22:
                    name = "TIME_ACT";
                    reg = ADXL362.TIME_ACT;
                    break;
                case 0x23:
                    name = "THRESH_INACT_L";
                    reg = ADXL362.THRESH_INACT_L;
                    break;
                case 0x24:
                    name = "THRESH_INACT_H";
                    reg = ADXL362.THRESH_INACT_H;
                    break;
                case 0x25:
                    name = "TIME_INACT_L";
                    reg = ADXL362.TIME_INACT_L;
                    break;
                case 0x26:
                    name = "TIME_INACT_H";
                    reg = ADXL362.TIME_INACT_H;
                    break;
                case 0x27:
                    name = "ACT_INACT_CTL";
                    reg = ADXL362.ACT_INACT_CTL;
                    break;
                case 0x28:
                    name = "FIFO_CONTROL";
                    reg = ADXL362.FIFO_CONTROL;
                    break;
                case 0x29:
                    name = "FIFO_SAMPLES";
                    reg = ADXL362.FIFO_SAMPLES;
                    break;
                case 0x2A:
                    name = "INTMAP1";
                    reg = ADXL362.INTMAP1;
                    break;
                case 0x2B:
                    name = "INTMAP2";
                    reg = ADXL362.INTMAP2;
                    break;
                case 0x2C:
                    name = "FILTER_CTL";
                    reg = ADXL362.FILTER_CTL;
                    break;
                case 0x2D:
                    name = "POWER_CTL";
                    reg = ADXL362.POWER_CTL;
                    break;
                case 0x2E:
                    name = "SELF_TEST";
                    reg = ADXL362.SELF_TEST;
                    break;
            }
            pc.printf("0x%x: %s=0x%x\n\r", i, name, ADXL362.read_reg(reg));
        }
    }
    else
    {
        pc.printf("Error");
        return(-1);
    }
    return(0);    
}
