#include "mbed.h"
#include <string.h>
#include <stdlib.h>

#if !DEVICE_ANALOGOUT
#error You cannot use this example as the AnalogOut is not supported on this device.
#else
AnalogOut my_output(PA_4);
#endif

#define PI        (3.141592653589793238462)
#define AMPLITUDE (1.0)    // x * 3.3V
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

// Configuration for sinewave output
#define BUFFER_SIZE (360)
uint16_t buffer[BUFFER_SIZE];


DigitalOut led1(LED3);
DigitalIn button(PC_13);
Serial pc(USBTX, USBRX);

int main()
{
    char buffer[32];
    char str1[32];
    char str2[32];
    int i = 0, n, spaceLoc = NULL;
    char c;
       
    pc.printf("Board is Running\n\r");
    
    while(1)
    {
        spaceLoc = NULL; // reset the counters
        i = 0;
        pc.printf("cps%% "); // print the line prefix
           
        while(1)
        {   
            c = pc.getc(); // grab input from serial
            pc.putc(c);
            
            if(c == 0x0d) // stop if return is pressed
            {
                break;
            }
            buffer[i] = c; // write the individual characters to buffer.
            i++;
        }
           
        n = strlen(buffer); // get the length of the written buffer
        for(i = 0; i < n; i++)
        {
            if(buffer[i] == ' ') // break it into two words seperated by a space
            {
                spaceLoc = i;
            }
        }
        
        if(spaceLoc == NULL) // if there is no space just get one word
        {
            spaceLoc = n;   
        }
        else
        {
            for(i = 0; (i + spaceLoc) < n; i++)
            {
                str2[i] = buffer[i + spaceLoc + 1];
            }  
        }
        
        for(i = 0; i < spaceLoc; i++)
        {
            str1[i] = buffer[i];   
        }
        
        str1[spaceLoc] = '\0'; // ensure null terminators are in place
        str2[n] = '\0';
           
        //each of these compares strings to see if the command has been typed
        if (strcmp(str1, "button") == 0)
        {
            pc.printf("\n\rOK\n\r");
            if(button.read())
            {
                pc.printf("RELEASED\n\r");
            }
            else
            {
                pc.printf("PRESSED\n\r");
            }
        }
        
        else if (strcmp(str1, "led") == 0)
        {
            pc.printf("\n\rOK\n\r");
            if(strcmp(str2, "on") == 0)
            {
                led1 = 1;
            }
            else if(strcmp(str2, "off") == 0)
            {
                led1 = 0;
            }
            else
            {
                    pc.printf("Wrong Message\n\r");
            }
        }
        
        else if (strcmp(str1, "blink") == 0)
        {
            pc.printf("\n\rOK\n\r");
            int n = 0;
            int num = atoi(str2);
            if(num > 0 && num < 11)
            {
                while(n < num)
                {
                    led1 = 1;
                    wait(0.5);
                    led1 = 0;
                    wait(0.5);
                    n++;
                }
                pc.printf("BLINKED %d times\n\r", num);
            }
            else
            {
                pc.printf("Please enter a number between 1 - 10\n\r");
            }
        }
        
        else if(strcmp(str1, "dc") == 0)
        {
            double vO = atof(str2);
            int voltage = (int) ((65535 * vO) / 3.3);
            uint16_t hexVolt = (uint16_t)voltage;
    
            if(vO >= 0.5 && vO <= 3.3)
            {
                pc.printf("Routing Power\n\r");
                my_output.write_u16(hexVolt);
            }
            else
            {
                pc.printf("Voltage Out of Range");   
            }
        }
        
        else
        {
            pc.printf("\n\rERR\n\r"); // Error message
        }
           
        for(int j = 0; j < 32; j++) // resets the strings/buffer and restarts
        {
            str1[j] = '\0';
            str2[j] = '\0';
            buffer[j] = '\0';
        }   
    } 
}