#include "mbed.h"
#include "ADXL362.h"
#include "MPL3115A2.h"
#include <stdio.h>
#include <stdlib.h>

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
InterruptIn event(PA_4);

char *arr[] = {
    "MPL_STATUS","MPL_OUT_P_MSB", "MPL_OUT_P_CSB","MPL_OUT_P_LSB","MPL_OUT_P_LSB",
    "MPL_OUT_T_LSB","MPL_DR_STATUS","MPL_OUT_P_DELTA_MSB","MPL_OUT_P_DELTA_MSB",
    "MPL_OUT_P_DELTA_LSB","MPL_OUT_T_DELTA_MSB","MPL_OUT_T_DELTA_LSB",
    "MPL_WHO_AM_I","MPL_F_STATUS","MPL_F_DATA","MPL_F_SETUP","MPL_TIME_DLY",
    "MPL_SYSMOD","MPL_INT_SOURCE","MPL_PT_DATA_CFG","MPL_BAR_IN_MSB",
    "MPL_BAR_IN_LSB","MPL_P_TGT_MSB","MPL_P_TGT_LSB","MPL_T_TGT","MPL_P_WND_MSB",
    "MPL_P_WND_LSB","MPL_T_WND","MPL_P_MIN_MSB","MPL_P_MIN_CSB","MPL_P_MIN_LSB",
    "MPL_T_MIN_MSB", "MPL_T_MIN_LSB", "MPL_P_MAX_MSB", "MPL_P_MAX_CSB",
    "MPL_P_MAX_LSB","MPL_T_MAX_MSB","MPL_T_MAX_LSB","MPL_CTRL_REG1",
    "MPL_CTRL_REG2","MPL_CTRL_REG3","MPL_CTRL_REG4","MPL_CTRL_REG5",
    "MPL_OFF_P","MPL_OFF_T","MPL_OFF_H" 
    };


int adxl362_reg_print(int start, int length) {
    int rvalue = 0;
    rvalue = adxl362.read_reg(ADXL362::DEVID_AD);
    if(rvalue!=0xAD){
        printf("value is %X\n\r",rvalue);
        printf("error\n\r");
        return -1;
        }
    else if(!(0 <= start && start < 46)){
        printf("error\n\r");
        return -1;
        }
    else if (!(length >= 0)){
        printf("error\n\r");
        return -1;
        }
    int i = 0;
    
    if (length!=0){
        for (i = start; i < start+length; i++){
            switch(i){
                case 0 : 
                    rvalue = adxl362.read_reg(ADXL362::DEVID_AD);
                    printf("0x00: DEVID_AD = %X \n\r", rvalue);
                    break;
                case 1 :
                    rvalue = adxl362.read_reg(ADXL362::DEVID_MST);
                    printf("0x01: DEVID_MST = %X \n\r", rvalue);
                    break;
                case 2 :
                    rvalue = adxl362.read_reg(ADXL362::PARTID);
                    printf("0x02: PARTID = %X \n\r", rvalue);
                    break;
                case 3 :
                    rvalue = adxl362.read_reg(ADXL362::REVID);
                    printf("0x03: REVID = %X \n\r", rvalue);
                case 4 :
                    rvalue = adxl362.read_reg(ADXL362::XDATA);
                    printf("0x08: XDATA = %X \n\r", rvalue);
                    break;
                case 5 :
                    rvalue = adxl362.read_reg(ADXL362::YDATA);
                    printf("0x09: YDATA = %X \n\r", rvalue);
                    break;
                case 6 :
                    rvalue = adxl362.read_reg(ADXL362::ZDATA);
                    printf("0x0A: ZDATA = %X \n\r", rvalue);
                    break;
                case 7 :
                    rvalue = adxl362.read_reg(ADXL362::STATUS);
                    printf("0x0B: STATUS = %X \n\r", rvalue);
                    break;
                case 8 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_ENTRIES_L);
                    printf("0x0C: FIFO_ENTRIES_L = %X \n\r", rvalue);
                    break;
                case 9 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_ENTRIES_H);
                    printf("0x0D: FIFO_ENTRIES_H = %X \n\r", rvalue);
                    break;
                case 10 :
                    rvalue = adxl362.read_reg(ADXL362::XDATA_L);
                    printf("0x0E: XDATA_L = %X \n\r", rvalue);
                    break;
                case 11 :
                    rvalue = adxl362.read_reg(ADXL362::XDATA_H);
                    printf("0x0F: XDATA_H = %X \n\r", rvalue);
                    break;
                case 12 :
                    rvalue = adxl362.read_reg(ADXL362::YDATA_L);
                    printf("0x10: YDATA_L = %X \n\r", rvalue);
                    break;
                case 13 :
                    rvalue = adxl362.read_reg(ADXL362::YDATA_H);
                    printf("0x11: YDATA_H = %X \n\r", rvalue);
                    break;
                case 14 :
                    rvalue = adxl362.read_reg(ADXL362::ZDATA_L);
                    printf("0x12: ZDATA_L = %X \n\r", rvalue);
                    break;
                case 15 :
                    rvalue = adxl362.read_reg(ADXL362::ZDATA_H);
                    printf("0x13: ZDATA_H = %X \n\r", rvalue);
                    break;
                case 16 :
                    rvalue = adxl362.read_reg(ADXL362::TEMP_L);
                    printf("0x14: TEMP_L = %X \n\r", rvalue);
                    break;
                case 17 :
                    rvalue = adxl362.read_reg(ADXL362::TEMP_H);
                    printf("0x15: TEMP_H = %X \n\r", rvalue);
                    break;
                case 18 :
                    rvalue = adxl362.read_reg(ADXL362::SOFT_RESET);
                    printf("0x1F: SOFT_RESET = %X \n\r", rvalue);
                    break;
                case 19 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_ACT_L);
                    printf("0x20: THRESH_ACT_L = %X \n\r", rvalue);
                    break;
                case 20 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_ACT_H);
                    printf("0x21: THRESH_ACT_H = %X \n\r", rvalue);
                    break;
                case 21 :
                    rvalue = adxl362.read_reg(ADXL362::TIME_ACT);
                    printf("0x22: TIME_ACT = %X \n\r", rvalue);
                    break;
                case 22 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_INACT_L);
                    printf("0x23: THRESH_INACT_L = %X \n\r", rvalue);
                    break;
                case 23 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_INACT_H);
                    printf("0x24: THRESH_INACT_H = %X \n\r", rvalue);
                    break;
                case 24 :
                    rvalue = adxl362.read_reg(ADXL362::TIME_INACT_L);
                    printf("0x25: TIME_INACT_L = %X \n\r", rvalue);
                    break;
                case 25 :
                    rvalue = adxl362.read_reg(ADXL362::TIME_INACT_H);
                    printf("0x26: TIME_INACT_H = %X \n\r", rvalue);
                    break;
                case 26 :
                    rvalue = adxl362.read_reg(ADXL362::ACT_INACT_CTL);
                    printf("0x27: ACT_INACT_CTL = %X \n\r", rvalue);
                    break;
                case 27 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_CONTROL);
                    printf("0x28: FIFO_CONTROL = %X \n\r", rvalue);
                    break;
                case 28 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_SAMPLES);
                    printf("0x29: FIFO_SAMPLES = %X \n\r", rvalue);
                    break;
                case 29 :
                    rvalue = adxl362.read_reg(ADXL362::INTMAP1);
                    printf("0x2A: INTMAP1 = %X \n\r", rvalue);
                    break;
                case 30 :
                    rvalue = adxl362.read_reg(ADXL362::INTMAP2);
                    printf("0x2B: INTMAP2 = %X \n\r", rvalue);
                    break;
                case 31 :
                    rvalue = adxl362.read_reg(ADXL362::FILTER_CTL);
                    printf("0x2C: FILTER_CTL = %X \n\r", rvalue);
                    break;
                case 32 :
                    rvalue = adxl362.read_reg(ADXL362::POWER_CTL);
                    printf("0x2D: POWER_CTL = %X \n\r", rvalue);
                    break;
                case 33 :
                    rvalue = adxl362.read_reg(ADXL362::SELF_TEST);
                    printf("0x2E: SELF_TEST = %X \n\r", rvalue);
                    break;
                default :
                    printf("ERROR:  NO REGISTER HERE\n\r");
                    break;
                   }        
            }
        }
    else {
        for (i = 0; i < 34; i++){
            switch(i){
                case 0 : 
                    rvalue = adxl362.read_reg(ADXL362::DEVID_AD);
                    printf("0x00: DEVID_AD = %X \n\r", rvalue);
                    break;
                case 1 :
                    rvalue = adxl362.read_reg(ADXL362::DEVID_MST);
                    printf("0x01: DEVID_MST = %X \n\r", rvalue);
                    break;
                case 2 :
                    rvalue = adxl362.read_reg(ADXL362::PARTID);
                    printf("0x02: PARTID = %X \n\r", rvalue);
                    break;
                case 3 :
                    rvalue = adxl362.read_reg(ADXL362::REVID);
                    printf("0x03: REVID = %X \n\r", rvalue);
                    break;
                case 4 :
                    rvalue = adxl362.read_reg(ADXL362::XDATA);
                    printf("0x08: XDATA = %X \n\r", rvalue);
                    break;
                case 5 :
                    rvalue = adxl362.read_reg(ADXL362::YDATA);
                    printf("0x09: YDATA = %X \n\r", rvalue);
                    break;
                case 6 :
                    rvalue = adxl362.read_reg(ADXL362::ZDATA);
                    printf("0x0A: ZDATA = %X \n\r", rvalue);
                    break;
                case 7 :
                    rvalue = adxl362.read_reg(ADXL362::STATUS);
                    printf("0x0B: STATUS = %X \n\r", rvalue);
                    break;
                case 8 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_ENTRIES_L);
                    printf("0x0C: FIFO_ENTRIES_L = %X \n\r", rvalue);
                    break;
                case 9 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_ENTRIES_H);
                    printf("0x0D: FIFO_ENTRIES_H = %X \n\r", rvalue);
                    break;
                case 10 :
                    rvalue = adxl362.read_reg(ADXL362::XDATA_L);
                    printf("0x0E: XDATA_L = %X \n\r", rvalue);
                    break;
                case 11 :
                    rvalue = adxl362.read_reg(ADXL362::XDATA_H);
                    printf("0x0F: XDATA_H = %X \n\r", rvalue);
                    break;
                case 12 :
                    rvalue = adxl362.read_reg(ADXL362::YDATA_L);
                    printf("0x10: YDATA_L = %X \n\r", rvalue);
                    break;
                case 13 :
                    rvalue = adxl362.read_reg(ADXL362::YDATA_H);
                    printf("0x11: YDATA_H = %X \n\r", rvalue);
                    break;
                case 14 :
                    rvalue = adxl362.read_reg(ADXL362::ZDATA_L);
                    printf("0x12: ZDATA_L = %X \n\r", rvalue);
                    break;
                case 15 :
                    rvalue = adxl362.read_reg(ADXL362::ZDATA_H);
                    printf("0x13: ZDATA_H = %X \n\r", rvalue);
                    break;
                case 16 :
                    rvalue = adxl362.read_reg(ADXL362::TEMP_L);
                    printf("0x14: TEMP_L = %X \n\r", rvalue);
                    break;
                case 17 :
                    rvalue = adxl362.read_reg(ADXL362::TEMP_H);
                    printf("0x15: TEMP_H = %X \n\r", rvalue);
                    break;
                case 18 :
                    rvalue = adxl362.read_reg(ADXL362::SOFT_RESET);
                    printf("0x1F: SOFT_RESET = %X \n\r", rvalue);
                    break;
                case 19 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_ACT_L);
                    printf("0x20: THRESH_ACT_L = %X \n\r", rvalue);
                    break;
                case 20 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_ACT_H);
                    printf("0x21: THRESH_ACT_H = %X \n\r", rvalue);
                    break;
                case 21 :
                    rvalue = adxl362.read_reg(ADXL362::TIME_ACT);
                    printf("0x22: TIME_ACT = %X \n\r", rvalue);
                    break;
                case 22 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_INACT_L);
                    printf("0x23: THRESH_INACT_L = %X \n\r", rvalue);
                    break;
                case 23 :
                    rvalue = adxl362.read_reg(ADXL362::THRESH_INACT_H);
                    printf("0x24: THRESH_INACT_H = %X \n\r", rvalue);
                    break;
                case 24 :
                    rvalue = adxl362.read_reg(ADXL362::TIME_INACT_L);
                    printf("0x25: TIME_INACT_L = %X \n\r", rvalue);
                    break;
                case 25 :
                    rvalue = adxl362.read_reg(ADXL362::TIME_INACT_H);
                    printf("0x26: TIME_INACT_H = %X \n\r", rvalue);
                    break;
                case 26 :
                    rvalue = adxl362.read_reg(ADXL362::ACT_INACT_CTL);
                    printf("0x27: ACT_INACT_CTL = %X \n\r", rvalue);
                    break;
                case 27 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_CONTROL);
                    printf("0x28: FIFO_CONTROL = %X \n\r", rvalue);
                    break;
                case 28 :
                    rvalue = adxl362.read_reg(ADXL362::FIFO_SAMPLES);
                    printf("0x29: FIFO_SAMPLES = %X \n\r", rvalue);
                    break;
                case 29 :
                    rvalue = adxl362.read_reg(ADXL362::INTMAP1);
                    printf("0x2A: INTMAP1 = %X \n\r", rvalue);
                    break;
                case 30 :
                    rvalue = adxl362.read_reg(ADXL362::INTMAP2);
                    printf("0x2B: INTMAP2 = %X \n\r", rvalue);
                    break;
                case 31 :
                    rvalue = adxl362.read_reg(ADXL362::FILTER_CTL);
                    printf("0x2C: FILTER_CTL = %X \n\r", rvalue);
                    break;
                case 32 :
                    rvalue = adxl362.read_reg(ADXL362::POWER_CTL);
                    printf("0x2D: POWER_CTL = %X \n\r", rvalue);
                    break;
                case 33 :
                    rvalue = adxl362.read_reg(ADXL362::SELF_TEST);
                    printf("0x2E: SELF_TEST = %X \n\r", rvalue);
                    break;
                default :
                    printf("ERROR:  NO REGISTER HERE\n\r");
                    break;
                   }        
            }     
        }
    
    return 0;
    }
    
int blink() {
        myled = 1; // LED is ON
        wait(2); // 2 sec
        myled = 0; // LED is OFF
        return 0;
}

int mpl3115_reg_print(int start, int length){
    
    uint8_t id;
    
    if ((start < 0) || (start > 45)) {
        pc.printf("break 1 \n\r");
        return -1;
        }
    if (length < 0) {
        pc.printf("break 2 \n\r");
        return -1;
        }
    id = pressure_sensor.getID();
    if (id!=0xC4) {
        pc.printf("break 3 \n\r");
        return -1;
        }
    
    uint8_t a[45];
            
    pressure_sensor.readRegs(start, a, length);
    
    int i = 0;
    for (i=0;i<length;i++){
        pc.printf("0x%X: %s is 0x%X \n\r",i, arr[i], a[i]);
        }
    return 0;

}

int printA(double* ar1, double* ar2, int start, int end){
    int i = 0;
    for (i = start; i < end; i++){
        pc.printf("value at %d : temp: %f pressure: %f \n\r",i,ar1[i], ar2[i]);
        }
    return 0;
}

int main() {
    int arraySize = 250; //approximately the time it takes to ride one elevator floors 1-6
    double altitudeReading[arraySize];
    double tempReading[arraySize];
    int i = 0, j = 0;

    j = mpl3115_reg_print(0, 45); 

    for (i = 0; i < arraySize; i++) { 
        altitudeReading[i] = -1;
    }
    for(j = 0; j < arraySize; j++) {
        tempReading[j] = -1;
        }
    i = 0;
    pc.printf("reading an altitude at this point at 10hz\r\n");
    pc.printf("Enter p to print, enter s to stop: ");
    while (1) {
        wait_us(100);
        altitudeReading[i] = pressure_sensor.getAltitude();
        i++;
        tempReading[j] = pressure_sensor.getTemperature();
        j++;
        if (i > arraySize) {
            i = 0;
        }
        if( j > arraySize) {
            j = 0;
        }
        if (pc.readable()) {
            char c = pc.getc();
            pc.printf("we read a char, it was %c\r\n",c);
            if (c == 'p') { //press p to show what is currently in the array
                pc.printf("read a p\r\n");
                int h = 0;
                for (h = 0; h < arraySize; h++) { 
                    pc.printf("temperature = %f, altitude = %f\r\n", tempReading[h], altitudeReading[h]);                
                }
            }
            if( c == 's') { //press s to get it to stop reading
                break;
                }
        }

    }
    
   

    
    
    
    
    
     /*     Lab 6 work
    
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    int8_t x,y,z; 
    int8_t nx, ny, nz;
    adxl362_reg_print(0, 0); // call register printing here
    adxl362_reg_print(0, 5);
    adxl362_reg_print(4, 6);
    //while (1) {adxl362_reg_print(0, 0);} to print forever
    
    int blink_c = 0;
    x=adxl362.scanx_u8();
    y=adxl362.scany_u8();
    z=adxl362.scanz_u8();

    while(1) { //detects knocks
        x=adxl362.scanx_u8();
        y=adxl362.scany_u8();
        z=adxl362.scanz_u8();
        wait_us(100);
        nx=adxl362.scanx_u8();
        ny=adxl362.scany_u8();
        nz=adxl362.scanz_u8();
        if ((abs(x-nx)>=4) || (abs(y-ny)>=4) || (abs(z-nz)>=4)){ 
            blink_c += 1;
            printf("number of knocks detected: %d\n\r",blink_c);
            blink();
        }
    } */
    
}