#include "mbed.h"
#include "ADXL362.h"
#include "MPL3115A2.h"
#include <stdio.h>
#include <stdlib.h>


DigitalOut myled(LED1);
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
InterruptIn event(PA_4);

Serial pc(SERIAL_TX, SERIAL_RX, 115200);
Serial device(PA_9, PA_10, 115200); 


void blink() {
    myled = 1; // LED is ON
    wait(1); // 1 sec
    myled = 0; // LED is OFF
    wait(1);

}

int main() {
    device.printf("AT+FSB=1\n");
    wait(1);
    device.printf("AT+NI=1,MTCDT-19400691\n");
    wait(1);
    device.printf("AT+NK=1,MTCDT-19400691\n");
    wait(1);
    device.printf("AT+JOIN\n");
    wait(1);
    
    int i = 0;
    while(i<3){
        blink();
        i++;
        }
    
    
    double altitudeReading;
    double tempReading;
    altitudeReading = pressure_sensor.getAltitude();
    tempReading = pressure_sensor.getTemperature();
    device.printf("AT+SEND=%.2f %.1f\n",tempReading,altitudeReading);
    
    while(1) {
        wait(3600);
        double altitudeReading;
        double tempReading;
        altitudeReading = pressure_sensor.getAltitude();
        tempReading = pressure_sensor.getTemperature();
        device.printf("AT+SEND=%.2f %.1f\n",tempReading,altitudeReading);
        }
    }
