#include "mbed.h"
#include "ADXL362.h"
#include <stdlib.h> 
 
 
 
 /* David Malone    davmalon@indiana.edu
    lab 6 
    please note that when testing my values, the values for x and y were averaginf round 253-254 and would rop upon being bumped or moved. 
    
    */ 
    
// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);

DigitalOut led1(LED1);//led setup

int adxl362_reg_print(int start, int length);  //function prototype for lab 6 functionality 

int main() {
    adxl362.reset();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    long unsigned int count = 0; 
    int x,y,z,test;
    wait_ms(1000); 
    x=adxl362.scanx();
    y=adxl362.scany();       
    z=adxl362.scanz();
    float average =  (253 + 253 + 73) / 3.0; 
    float currentReading = 0.0; 
    int numKnocks =0; 
    float movingAverage = average; 
    float temp; 
    float swap; 
    float sum; 
    float numbers[] = {average, average, average, average, average, average, average, average, average, average}; 
    printf("x = %d y = %d z = %d \r\n",x,y,z);
    while(1) {
        x=adxl362.scanx_u8();
        y=adxl362.scany_u8();
        z=adxl362.scanz_u8();
        adxl362_reg_print(0,46); //print all the registers 
        
        /* 
        
        //test = adxl362.read_reg(adxl362.DEVID_AD); //testing the device id register 
        //printf("x = %d y = %d z = %d Test = %0x\r\n",x,y,z,test);
        //int i = adxl362_reg_print(0,-1); 
        //knock reader
        sum = 0; 
        for(int j = 0; j < 10; j++) {
               sum = sum + numbers[j];  
        }//gets sum of samples for moving average 
        
        movingAverage = sum / 10.0 ; //moving average based upon 10 most recent samplings 
        
        currentReading = (abs(x) + abs(y) + abs(z)) / 3.0; 
        if(currentReading  * 1.5  < movingAverage) { //regitered a knock, lets get led and delay 
            numKnocks +=1; 
            led1 = 1; 
            printf("Number of knocks since reset: %d \r\n", numKnocks); 
            wait_ms(2000); //wait 2 seconds 
            led1 = 0; 
        }//end if  
        //swap moving array 
        temp = numbers[9];  
        numbers[9] = currentReading; 
        swap = numbers[8];
        numbers[8] = temp; 
        temp = numbers[7];  
        numbers[7] = swap; 
        swap = numbers[6];
        numbers[6] = temp; 
        temp = numbers[5];  
        numbers[5] = swap;
        swap = numbers[4];
        numbers[4] = temp; 
        temp = numbers[3];  
        numbers[3] = swap;
        swap = numbers[2];
        numbers[2] = temp; 
        temp = numbers[1]; 
        numbers[1] = swap; 
        numbers[0] = temp; 
        //this swaps the 10 array elements so that the new reading can be contained in the past 10 readings for a moving average; 
        
        count +=1;
        */ 
         
        wait_ms(100); 
        //printf("x = %d y = %d z = %d \r\n",x,y,z);
    }
}//end main

int adxl362_reg_print(int start, int length) {
        //check if start or length go beyond addr window
        if(start < 0x00 || start > 0x2E) { //check starting value 
            printf("recieved invalid starting point. range is 0-46 \n\r");      
            return -1;    
        }
        else if((start + length) > 0x2E) { //check input range
            printf("length too long. range is 0-46 \n\r");     
            return -1; 
        }
        else if(length < 0) { //cheack the length 
            printf("invalid length. Length must be positive \n\r");     
            return -1; 
        }
        else if(adxl362.read_reg(adxl362.DEVID_AD) != 0xAD) { //check the device id register 
            printf("Device id register has incorrect value of: %d \n\r", adxl362.read_reg(adxl362.DEVID_AD));     
            return -1; 
        }
        else {//checks passed, output registers 
            char *rtn = ""; 
            for(int i = start; i < length -1; i++) {
                printf("%02x :", i); //print address
                switch(i) {
                    case 0: 
                        rtn = "DEVID_AD";
                        printf("%s  =  %0x \n\r", rtn, adxl362.DEVID_AD);
                        break; 
                    case 1: 
                        rtn = "DEVID_MST"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.DEVID_MST);
                        break;
                    case 2: 
                        rtn = "PARTID"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.PARTID);
                    case 3:
                        rtn = "REVID";
                        printf("%s  =  %0x \n\r", rtn, adxl362.read_reg(adxl362.REVID));
                        break; 
                    case 4: // no opp
                        rtn = ""; 
                        break; 
                    case 5: //no opp
                        break; 
                    case 6: //no opp
                        break; 
                    case 7: //mo opp
                        break; 
                    case 8: 
                        rtn = "XDATA";
                        printf("%s  =  %0x \n\r", rtn, adxl362.XDATA);
                        break; 
                    case 9: 
                        rtn = "YDATA"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.YDATA);
                        break; 
                    case 10: 
                        rtn = "ZDATA"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.ZDATA);
                        break; 
                    case 11: 
                        rtn = "STATUS"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.STATUS);
                        break; 
                    case 12: 
                        rtn = "FIFO_ENTRIES_L"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.FIFO_ENTRIES_L);
                        break; 
                    case 13:
                        rtn = "FIFO_ENTRIES_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.FIFO_ENTRIES_H); 
                        break; 
                    case 14:
                        rtn = "XDATA_L";
                        printf("%s  =  %0x \n\r", rtn, adxl362.XDATA_L); 
                        break; 
                    case 15: 
                        rtn = "XDATA_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.XDATA_H);
                        break; 
                    case 16: 
                        rtn = "YDATA_L"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.YDATA_L);
                        break; 
                    case 17: 
                        rtn = "YDATA_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.YDATA_H);
                        break; 
                    case 18: 
                        rtn = "ZDATA_L"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.ZDATA_L);
                        break; 
                    case 19: 
                        rtn = "ZDATA_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.ZDATA_H);
                        break; 
                    case 20: 
                        rtn = "TEMP_L"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.TEMP_L);
                        break; 
                    case 21:
                        rtn = "TEMP_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.TEMP_H);
                        break; 
                    case 31:
                        rtn = "SOFT_RESET";  
                        printf("%s  =  %0x \n\r", rtn, adxl362.SOFT_RESET);
                        break; 
                    case 32: 
                        rtn = "THRESH_ACT_L";
                        printf("%s  =  %0x \n\r", rtn, adxl362.THRESH_ACT_L);
                        break; 
                    case 33: 
                        rtn = "THRESH_ACT_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.THRESH_ACT_H);
                        break; 
                    case 34: 
                        rtn = "TIME_ACT"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.TIME_ACT);
                        break; 
                    case 35: 
                        rtn = "THRESH_INACT_L";
                        printf("%s  =  %0x \n\r", rtn, adxl362.THRESH_INACT_L);
                        break; 
                    case 36: 
                        rtn = "THRESH_INACT_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.THRESH_INACT_H);
                        break; 
                    case 37: 
                        rtn = "TIME_INACT_L";
                        printf("%s  =  %0x \n\r", rtn, adxl362.TIME_INACT_L);
                        break; 
                    case 38:
                        rtn = "TIME_INACT_H"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.TIME_INACT_H);
                        break; 
                    case 39: 
                        rtn = "ACT_INACT_CTL"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.ACT_INACT_CTL);
                        break; 
                    case 40: 
                        rtn = "FIFO_CONTROL"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.FIFO_CONTROL);
                        break; 
                    case 41: 
                        rtn = "FIFO_SAMPLES"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.FIFO_SAMPLES);
                        break; 
                    case 42: 
                        rtn = "INTMAP1"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.INTMAP1);
                        break; 
                    case 43: 
                        rtn = "INTMAP2"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.INTMAP2);
                        break; 
                    case 44: 
                        rtn = "FILTER_CTL"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.FILTER_CTL);
                        break; 
                    case 45: 
                        rtn = "POWER_CTL"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.POWER_CTL);
                        break; 
                    case 46: 
                        rtn = "SELF_TEST"; 
                        printf("%s  =  %0x \n\r", rtn, adxl362.SELF_TEST);
                        break; 
                    default: 
                        rtn = ""; 
                        break; 
                    
                }//end switch  
            }//end loop
            return 1; //sucess
        }//
        return 0;//undetected failure  
            
    }//end reg_print function
    
    
    /*      getRegName()
        paramater int :: address of register 
        return String :: name of register 
            register list 
             DEVID_AD = 0x00,
        DEVID_MST = 0x01,
        PARTID = 0x02,
        REVID = 0x03,
        XDATA = 0x08,
        YDATA = 0x09,
        ZDATA = 0x0A,
        STATUS = 0x0B,
        FIFO_ENTRIES_L = 0x0C,
        FIFO_ENTRIES_H = 0x0D,
        XDATA_L = 0x0E,
        XDATA_H = 0x0F,
        YDATA_L = 0x10,
        YDATA_H = 0x11,
        ZDATA_L = 0x12,
        ZDATA_H = 0x13,
        TEMP_L = 0x14,
        TEMP_H = 0x15,
        // Reserved = 0x16;
        // Reserved = 0x17;
        SOFT_RESET = 0x1F,
        THRESH_ACT_L = 0x20,
        THRESH_ACT_H = 0x21,
        TIME_ACT = 0x22,
        THRESH_INACT_L = 0x23,
        THRESH_INACT_H = 0x24,
        TIME_INACT_L = 0x25,
        TIME_INACT_H = 0x26,
        ACT_INACT_CTL = 0x27,
        FIFO_CONTROL = 0x28,
        FIFO_SAMPLES = 0x29,
        INTMAP1 = 0x2A,
        INTMAP2 = 0x2B,
        FILTER_CTL = 0x2C,
        POWER_CTL = 0x2D,
        SELF_TEST = 0x2E,
        */ 
  
    
    
/* End of file */  