
#include "mbed.h"

#include "mbed.h"
#include <string.h>
#include <stdlib.h> 
 
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1); 
DigitalIn button(PC_13); 
AnalogOut my_output(PA_4);

#define PI        (3.141592653589793238462)
#define PHASE     (PI * 1) // 2*pi is one period
#define RANGE     (0x7FFF)
#define OFFSET    (0x7FFF)

// Configuration for sinewave output
#define BUFFER_SIZE (360)
uint16_t buffer[BUFFER_SIZE];
 
void LED(int a) {   
    //this is a function
    led1 = a; 
}
 
char* BUTTON() {
    if(!button.read()) {
        return "PRESSED"; 
        }
    else 
        return "RELEASED"; 
}
 
void BLINK(int cycles) {
     int x = 0;
     while(x < cycles) {
        led1 = 1; 
        wait(0.5);
        led1 = 0; 
        wait(0.5);
        x++;
    }//end loop
}//end BLINK

/* DC
    @param volts: an integer repreesenting output voltage || expected (0.5 - 3)
    function should take an input and out to the DAC a value representing voltage 
    */ 
void DC(float volts) {
    //Vout = (register volts/4096)*Vreference;    sample equation top represent output
    if(volts < 0.5 || volts > 3.0) {
        printf("Recieved too high voltage. Range in (0.5v -- 3.0 v) \n\r");     
    } else {
        float Vref = 3.3;
        uint16_t out = (4096 * (volts * 16))/Vref;
        printf("output accepted. Pushing to Dac :: %d\n\r", out); 
        my_output.write_u16(out); 
    }
 }//end DC 
 
 // Create the sinewave buffer
void calculate_sinewave(float amplitude){
  for (int i = 0; i < BUFFER_SIZE; i++) {
     double rads = (PI * i)/180.0; // Convert degree in radian
     
     buffer[i] = (uint16_t)(amplitude * (RANGE * (cos(rads + PHASE))) + OFFSET);
  }
}
  
 /* SINE 
    @param amplitude:: float representing peak to peak voltage (range (0.5v-3.0V)
    @param frequency:: int representing frequency for sine wave. (Range (100-500Hz) Resolution of 1. 
        function should generate a sinewave given amplitude and frequency. 
    */ 
 void SINE(float amplitude, int frequency) {
     
     //check for out of range values 
     if(amplitude < 0.5 || amplitude > 3.0) {//amplitude out of range
        printf("Amplitude out of range. accepted Range:: 0.5-3.0 \n\r"); 
        return;
     }
     else if(frequency < 100 || frequency > 500) {//frequency out of range 
        printf("frequency out of range. accepted Range:: 100-500 \n\r"); 
        return; 
     }
     else {
         printf("Output: Amplitude: %f  Frequency: %i \n\r", amplitude, frequency); 
         calculate_sinewave(amplitude); 
         while(1) {
             /* generate sine wave */ 
             for (int i = 0; i < BUFFER_SIZE; i++) {
                my_output.write_u16(buffer[i]);
               wait_us( (1000 / frequency));
              //  wait_us(1);
            } 
        }//infinite loop 
         
    }//end sine wave generation      
}//end SINE function
 
//null character '\0' 
//return character 0x0d
 
 
int main() {
    pc.printf("Nucleo is up and running\n\r");
    pc.printf(">"); 
    
    char led[] = {'L','E','D', '\0'}; 
    char* str1 = led; 
    char btn[] = {'B','U','T','T','O','N', '\0'}; 
    char* str2 = btn; 
    char blink[] = {'B', 'L', 'I', 'N', 'K','\0'}; 
    char* str3 = blink; 
    char *str4 = "DC"; 
    char *str5 = "SINE"; 
    //pointer used in string library to compar to char arrays for terminal commands 
    //input point of new character 
    while(true) {
        int a = 0; 
        char input[100]; 
        char curr = 0; 
        while (a < 100) {
            curr = pc.getc();//capture character typed in
            if(curr == 0x0d) {
               break;
            }
            pc.putc(curr);//display current character to terminal 
            input[a] = curr; //assign current character to array at index 'a' 
            a++; 
        }//end input char loop
        printf("\n\r"); 
        input[a] = '\0'; 
        char *token; 
        char *sp = " "; //just a space 
        token = strtok(input, sp);
        if((strcmp(token, str1)) == 0) {//compare inoput to LED command 
            // if first test succeds, capture oiption for on/off 
            token = strtok(NULL, sp);
            //printf("token: %s\n\r", token); 
            printf("entering LED Command\r\n");
           // printf("%d", strcmp(token, "ON\r"));
            if(strcmp(token, "ON") == 0) { //compare to on
                printf("turning LED On\r\n"); 
                LED(1); 
            }
            else if((strcmp(token, "OFF")) == 0) { //compare to off
                printf("turning LED off\n\r"); 
                LED(0); 
            }
            else {
                printf("invalid command parameter %s\n\r", token);     
            }
        }//end cond for LED command 
        else if((strcmp(token,str2)) == 0) {//check for button command
            char *temp = BUTTON(); 
            printf("button is '%s'\n\r", temp); 
        }//end cond for BUTTON COMMAND
        else if((strcmp(token, str3)) == 0)  {//check for blink command 
            //if first test succeds, grab second input, convert to INT, call blink() 
            token = strtok(NULL, sp); 
            int blinks = atoi(token); 
            BLINK(blinks); 
        }//end cond for BLINK COMMAND
        else if((strcmp(token, str4)) == 0) { //check for dc command 
            token = strtok(NULL, sp); 
            float volt = atof(token); 
            DC(volt); 
        }//end DC command check
        else if((strcmp(token, str5)) == 0) { //check for sine command 
            token = strtok(NULL, sp); 
            float amplitude = atof(token); 
            token = strtok(NULL, sp); 
            int frequency = atoi(token); 
            SINE(amplitude , frequency); 
        }//end sine command check
        else { 
            printf("error: Invalid input\n\r"); 
            printf("\trecieved token '%s'\n\r", token); 
        }
        token = strtok(input, sp);
        printf(">");
        
         
    }//end outer loop 
}//end main
/* end LAB 2 */ 
