#include "mbed.h"
#include "ADXL362.h"
#include "string.h"
#include "MPL3115A2.h"
#include <stdio.h>
#include <time.h>
 
DigitalOut led3(LED3);
Serial pc(USBTX, USBRX);
//AnalogIn gpio(D9);

//map of register values and names for the adxl
int aregids[34];
char* aregnames[34];
//populating the map
void initmap()
{
    aregids[0] = 0x00;
    aregids[1] = 0x01;
    aregids[2] = 0x02;
    aregids[3] = 0x03;
    aregids[4] = 0x08;
    aregids[5] = 0x09;
    aregids[6] = 0x0A;
    aregids[7] = 0x0B;
    aregids[8] = 0x0c;
    aregids[9] = 0x0D;
    aregids[10] = 0x0E;
    aregids[11] = 0x0F;
    aregids[12] = 0x10;
    aregids[13] = 0x11;
    aregids[14] = 0x12;
    aregids[15] = 0x13;
    aregids[16] = 0x14;
    aregids[17] = 0x15;
    aregids[18] = 0x1F;
    aregids[19] = 0x20;
    aregids[20] = 0x21;
    aregids[21] = 0x22;
    aregids[22] = 0x23;
    aregids[23] = 0x24;
    aregids[24] = 0x25;
    aregids[25] = 0x26;
    aregids[26] = 0x27;
    aregids[27] = 0x28;
    aregids[28] = 0x29;
    aregids[29] = 0x2A;
    aregids[30] = 0x2B;
    aregids[31] = 0x2C;
    aregids[32] = 0x2D;
    aregids[33] = 0x2E;

    aregnames[0] = "DEVID_AD";
    aregnames[1] = "DEVID_MST";
    aregnames[2] = "PARTID";
    aregnames[3] = "REVID";
    aregnames[4] = "XDATA";
    aregnames[5] = "YDATA";
    aregnames[6] = "ZDATA";
    aregnames[7] = "STATUS";
    aregnames[8] = "FIFO_ENTRIES_L";
    aregnames[9] = "FIFO_ENTRIES_H";
    aregnames[10] = "XDATA_L";
    aregnames[11] = "XDATA_H";
    aregnames[12] = "YDATA_L";
    aregnames[13] = "YDATA_H";
    aregnames[14] = "ZDATA_L";
    aregnames[15] = "ZDATA_H";
    aregnames[16] = "TEMP_L";
    aregnames[17] = "TEMP_H";
    aregnames[18] = "SOFT_RESET";
    aregnames[19] = "THRESH_ACT_L";
    aregnames[20] = "THRESH_ACT_H";
    aregnames[21] = "TIME_ACT";
    aregnames[22] = "THRESH_INACT_L";
    aregnames[23] = "THRESH_INACT_H";
    aregnames[24] = "TIME_INACT_L";
    aregnames[25] = "TIME_INACT_H";
    aregnames[26] = "ACT_INACT_CTL";
    aregnames[27] = "FIFO_CONTROL";
    aregnames[28] = "FIFO_SAMPLES";
    aregnames[29] = "INTMAP1";
    aregnames[30] = "INTMAP2";
    aregnames[31] = "FILTER_CTL";
    aregnames[32] = "POWER_CTL";
    aregnames[33] = "SELF_TEST";
}

//map of register values and names for the adxl
char mregids[46];
char* mregnames[46];
//populating the map
void minitmap()
{
    mregids[0] = 0x00;
    mregids[1] = 0x01;
    mregids[2] = 0x02;
    mregids[3] = 0x03;
    mregids[4] = 0x04;
    mregids[5] = 0x05;
    mregids[6] = 0x06;
    mregids[7] = 0x07;
    mregids[8] = 0x08;
    mregids[9] = 0x09;
    mregids[10] = 0x0A;
    mregids[11] = 0x0B;
    mregids[12] = 0x0C;
    mregids[13] = 0x0D;
    mregids[14] = 0x0E;
    mregids[15] = 0x0F;
    mregids[16] = 0x10;
    mregids[17] = 0x11;
    mregids[18] = 0x12;
    mregids[19] = 0x13;
    mregids[20] = 0x14;
    mregids[21] = 0x15;
    mregids[22] = 0x16;
    mregids[23] = 0x17;
    mregids[24] = 0x18;
    mregids[25] = 0x19;
    mregids[26] = 0x1A;
    mregids[27] = 0x1B;
    mregids[28] = 0x1C;
    mregids[29] = 0x1D;
    mregids[30] = 0x1E;
    mregids[31] = 0x1F;
    mregids[32] = 0x20;
    mregids[33] = 0x21;
    mregids[34] = 0x22;
    mregids[35] = 0x23;
    mregids[36] = 0x24;
    mregids[37] = 0x25;
    mregids[38] = 0x26;
    mregids[39] = 0x27;
    mregids[40] = 0x28;
    mregids[41] = 0x29;
    mregids[42] = 0x2A;
    mregids[43] = 0x2B;
    mregids[44] = 0x2C;
    mregids[45] = 0x2D;

    mregnames[0] = "STATUS";
    mregnames[1] = "OUT_P_MSB";
    mregnames[2] = "OUT_P_CSB";
    mregnames[3] = "OUT_P_LSB";
    mregnames[4] = "OUT_T_MSB";
    mregnames[5] = "OUT_T_LSB";
    mregnames[6] = "DR_STATUS";
    mregnames[7] = "OUT_P_DELTA_MSB";
    mregnames[8] = "OUT_P_DELTA_CSB";
    mregnames[9] = "OUT_T_DELTA_MSB";
    mregnames[10] = "OUT_T_DELTA_LSB";
    mregnames[11] = "WHO_AM_I";
    mregnames[12] = "F_STATUS";
    mregnames[13] = "F_DATA";
    mregnames[14] = "F_SETUP";
    mregnames[15] = "TIME_DLY";
    mregnames[16] = "SYSMOD";
    mregnames[17] = "INT_SOURCE";
    mregnames[18] = "SOFT_RESET";
    mregnames[19] = "PT_DATA_CFG";
    mregnames[20] = "BAR_IN_MSB";
    mregnames[21] = "BAR_IN_LSB";
    mregnames[22] = "P_TGT_MSB";
    mregnames[23] = "P_TGT_LSB";
    mregnames[24] = "T_TGT";
    mregnames[25] = "P_WND_MSB";
    mregnames[26] = "P_WND_LSB";
    mregnames[27] = "T_WND";
    mregnames[28] = "P_MIN_MSB";
    mregnames[29] = "P_MIN_CSB";
    mregnames[30] = "P_MIN_LSB";
    mregnames[31] = "T_MIN_MSB";
    mregnames[32] = "T_MIN_LSB";
    mregnames[33] = "P_MAX_MSB";
    mregnames[34] = "P_MAX_CSB";
    mregnames[35] = "P_MAX_LSB";
    mregnames[36] = "T_MAX_MSB";
    mregnames[37] = "T_MAX_LSB";
    mregnames[38] = "CTRL_REG1";
    mregnames[39] = "CTRL_REG2";
    mregnames[40] = "CTRL_REG3";
    mregnames[41] = "CTRL_REG4";
    mregnames[42] = "CTRL_REG5";
    mregnames[43] = "OFF_P";
    mregnames[44] = "OFF_T";
    mregnames[45] = "OFF_H";
}

// Interface pulled from ADXL362.cpp
// ADXL362::ADXL362(PinName CS, PinName MOSI, PinName MISO, PinName SCK) :
ADXL362 adxl362(PA_0,PA_7,PA_6,PA_1);

// Selects SDA as I2C1_SDA on pin PB_7
// Selects SCL on I2C1_SCL on pin PB_6
// The I2C address of the pressure sensor is fixed at 0x60.
MPL3115A2 pressure(PB_7, PB_6, 0x60);

int adxl362_reg_print(int s, int l)
{
    //check s is between 0x00 and 0x2E
    if(s > 0x2E || s < 0x00) {
        printf("adx: requires start between 0x00 and 0x2E; given %d (0x%01x)\n", s,s);
        return -1;
    } else if(l < 0) {
        //check length > 0
        printf("adx: requires length >= 0, given %d\n", l);
        return -1;
    } else {
        // start sending stuff
        //first check DEVID_AD == 0xAD
        uint8_t devid = adxl362.read_reg(ADXL362::DEVID_AD);
        //printf("devid = %d\n", devid);
        if(devid != 0xAD) {
            printf("error: DEVID_AD is not 0xAD; exiting\n");
            return -1;
        } else {
            //now do stuff
            //if length == 0, send everything from s to end of registers
            //else print from s to l
            // formula : range = end - start - length
            // area = start + range
            int stop = 0;
            if(l == 0) {
                stop = 34;
            } else {
                stop = s + l;
            }
            int in = s;
            while(in < stop) {
                //get register name
                char * name = aregnames[in]; //GET NAME
                ADXL362::ADXL362_register_t reg = (ADXL362::ADXL362_register_t) aregids[in];
                uint8_t val = adxl362.read_reg(reg); //GET REG VAL
                //print val
                printf("0x%01x: %s=0x%01x\r\n", aregids[in], name, val);
                in++;
            }
        }
    }
    return 0;
}

void knocks()
{
    int8_t x,y,z, initx, inity, initz;
    //initial values of x, y, and z.
    //These values are the baseline for the accelerometer; knocks are detected
    // in relation to these initial values
    initx=adxl362.scanx_u8();
    inity=adxl362.scany_u8();
    initz=adxl362.scanz_u8();
    int count = 0;
    int bs = 7;

    while(1) {
        //get the values of x, y, and z to test for a knock
        x=adxl362.scanx_u8();
        y=adxl362.scany_u8();
        z=adxl362.scanz_u8();
        //if x, y, or z vary from baseline by at least bs, a knock has occured.
        if(x > initx+bs || y > inity+bs || z > initz+bs || x < initx-bs || y < inity-bs || z < initz-bs) {
            led3 = 1;
            count++;
            printf("number of knocks: %d\r\n", count);
            wait_ms(2000);
            led3 = 0;
        }
        //printf("x = %d y = %d z = %d\r\n",x,y,z);
        wait_ms(100);
    }
}

int mpl3115_reg_print(int s, int l)
{
    if(s > 0x2D || s < 0x00) {
        printf("mpl: requires start between 0x00 and 0x20; given %d (0x%01x)\n\r", s,s);
        return -1;
    } else if(l < 0) {
        //check length > 0
        printf("mpl: requires length >= 0, given %d\n\r", l);
        return -1;
    } else {
        //else do stuff
        uint8_t id = pressure.getID();
        //printf("whoami = 0x%01x", id);
        if(id != 0xC4) {
            printf("error: WHO_AM_I is not 0xC4; exiting\n");
            return -1;
        } else {
            //now do stuff
            //if length == 0, send everything from s to end of registers
            //else print from s to l
            // formula : range = end - start - length
            // area = start + range
            int stop = 0;
            if(l == 0) {
                stop = 46;
            } else {
                stop = s + l;
            }
            int in = s;
            while(in < stop) {
                //get register name
                char * name = mregnames[in]; //GET NAME
                int reg = mregids[in];
                uint8_t val;
                pressure.readRegs(reg,&val,sizeof(uint8_t)); //GET REG VAL
                //print val
                printf("0x%01x: %s=0x%01x\r\n", mregids[in], name, val);
                in++;
            }//while
        }//else
    }//else
    return 0;
}//print mpl

int measureAlt()
{

    printf("measuring things\r\n");

    uint8_t id = pressure.getID();
    //printf("whoami = 0x%01x\r\n", id);
    if(id != (uint8_t) 0xC4) {
        printf("error: WHO_AM_I is not 0xC4; exiting\r\n");
        return -1;
    } else {
        double data[900];

        int ind = 0;

        //set sample_time
        wait_ms(100);
        uint8_t st = pressure.getCTRL_REG1();
        uint8_t msk = 0x8f;
        //printf("CTL_REG1 = 0x%05x\r\n", st);
        pressure.setCTRL_REG1(msk);
        pressure.activate();
        //printf("CTL_REG1 = 0x%05x\r\n", pressure.getCTRL_REG1());
        

        //pressure stuff
        uint8_t tmp[3] ;
        uint32_t pres ;


        //GPIO pin indicates sampling should begin -- if voltage == 3.3, start
        while(ind < 900 && !pc.readable()) {
            printf("measuring...\r\n");
            //then we measure
            //pressure and temperature sampled at 10times/second (10 hz)
            //LED blinks during sampling at 1 hz (1 time/second)
            led3 = 1;
            for(int i = 0; i < 10; i++) {
                pres = pressure.getPressure();
                //pressure.readRegs(mregids[1], tmp, 3) ;
                //pres = ((tmp[0]<<16)|(tmp[1]<<8)|(tmp[2])) >> 6;
                data[ind++] = pres;
                data[ind++] = pressure.getTemperature();
                wait_ms(100);
            }//for
            led3 = 0;
            for(int i = 0; i < 10; i++) {
                pres = pressure.getPressure();
                //pressure.readRegs(mregids[1], tmp, 3) ;
                //pres = ((tmp[0]<<16)|(tmp[1]<<8)|(tmp[2])) >> 6;
                data[ind++] = pres;
                data[ind++] = pressure.getTemperature();
                wait_ms(100);
            }//for
        }//while
        
        int pind = 0;
        int pend = ind;
        char in;
        int ch;
        char p = 'p';
        bool ex = false;
        while(!ex) {
            printf("p%% ");
            while((ch = pc.getc()) != 13) {
                pc.putc(ch);
                in = ch;
            }//while
            if(in == p) {
                while(pind < pend) {
                    pc.printf("\n\r%f\t%f", data[pind],data[pind+1]);
                    pind += 2;
                    ex = true;
                }//while
            } else {
                in = 0;
            }//if/else
        }//while
        
        pc.printf("\n\r");
    return 0;
    }//else
}//measureAlt

int main()
{
    initmap();
    minitmap();
    adxl362.reset();
    pressure.activate();
    wait_ms(600); // we need to wait at least 500ms after ADXL362 reset
    adxl362.set_mode(ADXL362::MEASUREMENT);
    int start, length;
    start = 0;
    length = 0;
    //while(1){
    //adxl362_reg_print(start, length);
       mpl3115_reg_print(start, length);
    //}
    //knocks();

    measureAlt();
    //while(1);
}
