#include "mbed.h"
#include "MPL3115A2.h"
#include "string.h"
#include "ATParser.h"

MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial device(PA_9, PA_10);  // tx, rx
DigitalOut myled(LED1);


/*  Checks to see if the xDot has a buffered message OK to 
    confirm that operation has succeeded
*/
int confirmOK() { 
    // Wait until device has a response 
    while (!device.readable()) {
        wait_ms(100);
    }
    int bufferSize = 100;
    char buf[bufferSize];
    int i = 0;
    for (i = 0; i < bufferSize; i++) {
        buf[i] = 0;
    }
    i = 0;
    
    //Read message from device into buffer
    for (i = 0; device.readable(); i++) { 
        buf[i] = device.getc();
        if (buf[i] == '\n') { 
        // Read new line so check to see if we got an OK or Error
        // else keep reading til we get one
        //pc.printf("The message from the device is %s\r\n",buf);
            if (!strncmp("OK",buf,2)) {
                //pc.printf("I compared against %s and got OK\r\n",buf);
                return 1;
            } else if (!strncmp("ERROR",buf,5)) { 
                //pc.printf("I compared against %s and got ERROR\r\n",buf);
                return 0;
            }
            return confirmOK();
        }
        if (i >= bufferSize) { 
            return 0;
        }
    }
    return confirmOK();
}
/*  Sends a message to the xDot
    Messages are expected to end in \n so that an OK confirmation will be 
    recieved
*/
int sendAtMessage(char * message) {
    while (*message) { 
        device.putc(*message);
        message++;
    }
    return confirmOK();
}

/*
Send a message to the xDot without checking for acknowledge
*/
void sendAtMessageNACK(char * message, int size) {
    int i = 0;
    while (i < size) { 
        device.putc(*message);
        //wait_ms(500); // Not succesfully sending the message unless it waits.
        //pc.printf("putting %c on device\n\r", *message);
        message++;
        i++;
    }
}
int main() {
    pc.baud(115200);
    device.baud(115200);
   
    pc.printf("Starting program\n\r");
    
    myled = 0;
    
    if (!sendAtMessage("AT\n")) { 
        pc.printf("xDot not responding to message\n\r");
    }
    //Try to connect xDot to network
    // Provice network name
    char networkName[] = "AT+NI=1,MTCDT-19400691\n";
    if (!sendAtMessage(networkName)) {
        pc.printf("Unable to set network name\n\r");
    }
    //Provide network passphrase
    char networkPassphrase[] = "AT+NK=1,MTCDT-19400691\n";
    if (!sendAtMessage(networkPassphrase)) { 
        pc.printf("Network passphrase not successfully set\n\r");
    }
    //Set the frequency sub band
    char frequencySubBand[] = "AT+FSB=1\n";
    if (!sendAtMessage(frequencySubBand)) { 
        pc.printf("Network frequency SubBand not successfully set\n\r");
    }
    //Join the network
    char joinNetwork[] = "AT+JOIN\n"; // Unable to join network atm.
    if (!sendAtMessage(joinNetwork)) { 
        pc.printf("Failed to joined the network\n\r");
    }
    pc.printf("I got here\r\n");
    int i = 0; 
    for (i = 0; i < 48; i++) {
        int tempBufSize = 4;
        int presBufSize = 6;
        double temp = pressure_sensor.getTemperature();
        char tempBuf[tempBufSize];
        double pres = pressure_sensor.getPressure();
        char presBuf[presBufSize];
        //pc.printf("Current temp is %f\n\r",temp);
        //pc.printf("Current pres is %f\n\r",pres);
        sprintf(tempBuf, "%2.1f",temp);
        sprintf(presBuf, "%4.1f",pres);
        //pc.printf("After convert with sprintf temp = %s\n\r",tempBuf);
        //pc.printf("After convert with sprintf pres = %s\n\r",presBuf);
        sendAtMessageNACK("AT+SEND=",8);
        sendAtMessageNACK(tempBuf,tempBufSize);
        sendAtMessageNACK(",",1);
        sendAtMessageNACK(presBuf,presBufSize);
        //wait_ms(500);
        if (sendAtMessage("\n")) { 
            pc.printf("message succesfully sent\n\r");
            myled = 1;
        }  else {
            pc.printf("Failed to send the message for some reason\r\n");   
        }
        
        wait(1000);
       
    } 
    
    //When an s is read from the serial pc,
    // read the current pressure/temperature from the I2C pressure sensor
    // and send it to the MQTT server pivot.iuiot
    //Unsure of what size to set Buffer so that it doesn't go over
    //when trying to send a message
    
    /*
    while(1) {
        if (pc.readable()) {
            //pc.printf("pc.readable\r\n");
            if (pc.getc() == 's') { 
                pc.printf("I recieved an s\r\n");
                int tempBufSize = 4;
                int presBufSize = 6;
                double temp = pressure_sensor.getTemperature();
                char tempBuf[tempBufSize];
                double pres = pressure_sensor.getPressure();
                char presBuf[presBufSize];
                pc.printf("Current temp is %f\n\r",temp);
                pc.printf("Current pres is %f\n\r",pres);
                sprintf(tempBuf, "%2.1f",temp);
                sprintf(presBuf, "%4.1f",pres);
                pc.printf("After convert with sprintf temp = %s\n\r",tempBuf);
                pc.printf("After convert with sprintf pres = %s\n\r",presBuf);
                sendAtMessageNACK("AT+SEND=",8);
                sendAtMessageNACK(tempBuf,tempBufSize);
                sendAtMessageNACK(",",1);
                sendAtMessageNACK(presBuf,presBufSize);
                wait_ms(500);
                if (sendAtMessage("\n")) { 
                    pc.printf("message succesfully sent\n\r");
                }  else {
                    pc.printf("Failed to send the message for some reason\r\n");   
                }
            }
        }
    }
    */
    
    /*
    while(1) {
        if(pc.readable()) {
            device.putc(pc.getc());
            myled = !myled;
        }
        if(device.readable()) {
            pc.putc(device.getc());
            myled = !myled;
        }
    }
    */
}