#include "mbed.h"
#include "MPL3115A2.h"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
InterruptIn event(PA_4); // GPIO pin being read for when to start Elevator Altimeter

// Selects SDA as I2C1_SDA on pin PB_7
// Selects SCL on I2C1_SCL on pin PB_6
// The I2C address of the pressure sensor is fixed at 0x60. 
MPL3115A2 pressure_sensor(PB_7,PB_6,0x60);
int mpl3115_reg_print(int start, int length);

int main() {
    pc.printf("starting program\n\r");
    
    
    //Prints out registrys 
    // Use for demo
    while(1) {
        mpl3115_reg_print(0,0);
    }
    
    
    //Test is getID returns the correct value and we are getting good readings
    pc.printf("\n\r*** MPL3115A2 Pressure/Temperature Sensor Test *** \n\r");
    uint8_t id;
    while ((id=pressure_sensor.getID())!=0xC4) {
        pc.printf("Status read unsuccessful: Value = 0x%02x\n\r",id);
        pc.printf("Check wiring to the pressure sensor\n\r",id);
        pc.printf("Retesting for correct ID in 1 second...\n\r");
        wait(1);
    }
    pc.printf("Status read successfully: Value = 0x%02x\n\r",id);
    pc.printf("***1hz readings from the pressure sensor***\n\r");
    int i = 0;
    int arraySize = 1000;
    double altitudeReading[arraySize];
    // Set all elements in array to -1, so easier to tell what start values were
    for (i = 0; i < arraySize; i++) { 
        altitudeReading[i] = -1;
    }
    i = 0;
    while (1) {
        if(event.read()) {// if pin A3 has electricy
            pc.printf("reading an altitude at this point\r\n");
            altitudeReading[i] = pressure_sensor.getAltitude();
            i++;
            if (i > arraySize) {
                i = 0;
            }
        }
        if (pc.readable()) { // check if we need to print everything
            char c = pc.getc();
            pc.printf("we read a char, it was %c\r\n",c);
            if (c == 'p') {
                pc.printf("read a p\r\n");
                int j = 0;
                for (j = 0; j < arraySize; j++) { 
                    pc.printf("j = %d, altitude = %f\r\n", j, altitudeReading[j]);                
                }
            }
        }
        wait_ms(500); // Half a second is spent between each measure
    }
}   

int mpl3115_reg_print(int start, int length)  {
    int maxLength = 0x2E;
    int end = maxLength;
    uint8_t data;
    if ((start + length) < end) {
        end = (start + length); // so it only goes to the length
    }
    if (length == 0) { 
        end = maxLength; // so it prints till the end
    }
    
    // Check if start is within registry
    if (start < 0 || start > end) {
        pc.printf("Error: start value passed to mpl3115_reg_print outside of range of registry\n\r");
        return -1;
    }
    // check if length is negative
    if (length < 0) {
        pc.printf("Error: length passed to mpl3115_reg_print is negative\n\r");
        return -1;
    }
    // check if valid communication with device going
    if ((data=pressure_sensor.getID())!=0xC4) {
        pc.printf("Error: Unable to read from WHO_AM_I register\n\r");
        return -1;
    }
    // array of names of the registries
    char regNames [0x2E][30] = {
        "STATUS", "OUT_P_MSB", "OUT_P_CSB",
        "OUT_P_LSB", "OUT_T_MSB", "OUT_T_LSB",
        "DR_STATUS", "OUT_P_DELTA_MSB", "OUT_P_DELTA_CSB",
        "OUT_P_DELTA_LSB", "OUT_T_DELTA_MSB", "OUT_T_DELTA_LSB",
        "WHO_AM_I", "F_STATUS", "F_DATA", 
        "F_SETUP", "TIME_DLY", "SYSMOD", 
        "INT_SOURCE", "PT_DATA_CFG", "BAR_IN_MSB",
        "BAR_IN_LSB", "P_TGT_MSB", "P_TGT_LSB",
        "T_TGT", "P_WND_MSB", "P_WND_LSB",
        "T_WND", "P_MIN_MSB", "P_MIN_CSB",
        "P_MIN_LSB", "T_MIN_MSB", "T_MIN_LSB",
        "P_MAX_MSB", "P_MAX_CSB", "P_MAX_LSB",
        "T_MAX_MSB", "T_MAX_LSB", "CTRL_REG1",
        "CTRL_REG2","CTRL_REG3","CTRL_REG4",
        "CTRL_REG5", "OFF_P", "OFF_T", "OFF_H" 
        };
    // For loop to print out each registry value
    for (int i = start; i < end; i++) { 
        pressure_sensor.readRegs(i,&data,8);
        pc.printf("%#04x: %s=%#04x\n\r", i, regNames[i], data); // Print register
        wait_ms(50);
    } 
    return 0;
}