/*
 * Copyright (c) 2015 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "MPL3115.h"
 #include "mbed.h"

MPL3115::MPL3115(PinName sda, PinName scl) : MPL3115_i2c(sda,scl)
 {
       
 }
    
 void MPL3115::MPL3115_config(void)
 {
   char d[2]; 
   d[0] = MPL3115_CTRL_REG1;                     //Puts device in Standby mode
   d[1] = 0x00; 
   MPL3115_i2c.write(MPL3115_I2C_ADDRESS, d,2);   
          
   
   d[0] = MPL3115_CTRL_REG1;                     //Puts device in Active mode and in altimeter mode
   d[1] = 0x81;
   MPL3115_i2c.write(MPL3115_I2C_ADDRESS, d, 2);   
      
 }
 
 int MPL3115::readReg(int address) { 
    int length = 8;
    char d[1];
    char readData[length];
    
    d[0] = MPL3115_STATUS;
    MPL3115_i2c.write(MPL3115_I2C_ADDRESS,d,1,true);
    MPL3115_i2c.read(MPL3115_I2C_ADDRESS,readData,length);
    for (int i = 0; i < length; i++) { 
        if (readData[i]) { 
            printf("The readData of %d is 1\r\n",i);
        } else {
            printf("The readData of %d is 0\r\n",i);
        }
    }
    
    //printf("The readData is : %s\r\n", readData);
    int returnValue = 0;
    for (int i = 0; i < length; i++) {
        returnValue << readData[i];
    }
    
    return returnValue;

}
 
  
 
 void MPL3115::acquire_MPL3115_data_Altitude_in_m(float * alt_data)
 {
  
   char data_bytes[7];
   char d[1];
   d[0]=MPL3115_STATUS;
   MPL3115_i2c.write(MPL3115_I2C_ADDRESS,d,1,true);  // Read the 6 data bytes - LSB and MSB for X, Y and Z Axes.
   MPL3115_i2c.read(MPL3115_I2C_ADDRESS,data_bytes,5);
   alt_data[0]= (float)((short)((data_bytes[1] << 8 ) | data_bytes[2])) + (float)(data_bytes[3]>>4) * 0.0625;
  
  
 }