#include "mbed.h"
#include "string.h"
#include "TSL2561.h"
#include "ATParser.h"

BufferedSerial pc(SERIAL_TX, SERIAL_RX);
BufferedSerial device(PA_9, PA_10);  // tx, rx
DigitalOut myled(LED1);
TSL2561 lightsensor(PB_7,PB_6);

/*  Checks to see if the xDot has a buffered message OK to 
    confirm that operation has succeeded
*/
int confirmOK() { 
    // Wait until device has a response 
    while (!device.readable()) {
        wait_ms(100);
    }
    int bufferSize = 100;
    char buf[bufferSize];
    int i = 0;
    for (i = 0; i < bufferSize; i++) {
        buf[i] = 0;
    }
    i = 0;
    
    //Read message from device into buffer
    for (i = 0; device.readable(); i++) { 
        buf[i] = device.getc();
        if (buf[i] == '\n') { 
        // Read new line so check to see if we got an OK or Error
        // else keep reading til we get one
        //pc.printf("The message from the device is %s\r\n",buf);
            if (!strncmp("OK",buf,2)) {
                //pc.printf("I compared against %s and got OK\r\n",buf);
                return 1;
            } else if (!strncmp("ERROR",buf,5)) { 
                //pc.printf("I compared against %s and got ERROR\r\n",buf);
                return 0;
            }
            return confirmOK();
        }
        if (i >= bufferSize) { 
            return 0;
        }
    }
    return confirmOK();
}
/*  Sends a message to the xDot
    Messages are expected to end in \n so that an OK confirmation will be 
    recieved
*/
int sendAtMessage(char * message) {
    while (*message) { 
        device.putc(*message);
        message++;
    }
    return confirmOK();
}

/*
Send a message to the xDot without checking for acknowledge
*/
void sendAtMessageNACK(char * message, int size) {
    int i = 0;
    while (i < size) { 
        device.putc(*message);
        //wait_ms(500); // Not succesfully sending the message unless it waits.
        //pc.printf("putting %c on device\n\r", *message);
        message++;
        i++;
    }
}
/*
Copies copyFrom into the CopyTo string.
/StartTo is the starting index of Copyto
copyFromSize is the size of the string being copied
//EX: Copyfrom = "HI", Copyto = "____", startTo = 1, copyFromSize = 2
// end result of copyTo = "_HI_"
*/
void copyString(char *copyTo, char *copyFrom, int startTo, int copyFromSize) { 
    int i;
    for (i = 0; i < copyFromSize; i++) { 
        copyTo[i+startTo] = copyFrom[i];    
    }
}


int main() {
    pc.baud(115200);
    device.baud(115200);
    myled = 1;
    wait(1);
    myled = 0;
  
    //Array to hold data
    int dataArraySize = 24;
    int lightBufSize = 8;
    char dataArray[dataArraySize][lightBufSize];
          
    pc.printf("Starting program\n\r");  
    
    if (!sendAtMessage("AT\n")) { 
        pc.printf("xDot not responding to message\n\r");
    }
    // Provice network name
    char networkName[] = "AT+NI=1,MTCDT-19400691\n";
    if (!sendAtMessage(networkName)) {
        pc.printf("Unable to set network name\n\r");
    }
    //Provide network passphrase
    char networkPassphrase[] = "AT+NK=1,MTCDT-19400691\n";
    if (!sendAtMessage(networkPassphrase)) { 
        pc.printf("Network passphrase not successfully set\n\r");
    }
    //Set the frequency sub band
    char frequencySubBand[] = "AT+FSB=1\n";
    if (!sendAtMessage(frequencySubBand)) { 
        pc.printf("Network frequency SubBand not successfully set\n\r");
    }
    
    //Set data transmission rate
    if (!sendAtMessage("AT+TXDR=1\n")) {
        pc.printf("Unable to set dataRate\n\r");
    }
    
    if (!sendAtMessage("AT+ACK=8\n")) { 
        pc.printf("Unable to set acknowledgement requirement\n\r");
    }
    pc.printf("I got here\n\r");

    //Join the network
    char joinNetwork[] = "AT+JOIN\n"; // Unable to join network atm.
    while (!sendAtMessage(joinNetwork)) { 
        pc.printf("Failed to joined the network\n\r");
        wait(1);
    }
    
    while (!sendAtMessage("AT+SEND=TestMessage\n")) {
         myled=0;  
    }
    myled = 1;
    
    while(1) {
        //Collect data
        int i = 0;
        for (i = 0; i < dataArraySize; i++) {
            double light = lightsensor.lux();
            pc.printf("Current light is %f\n\r",light);
            sprintf(dataArray[i], "%2.5f",light);
            pc.printf("After convert with sprintf light = %s\n\r",dataArray[i]);
            wait_ms(500);
        }
        //pc.printf("%s\n\r",dataArray);
        
        
        for (i = 0; i < 6; i++) {
            int j;
            sendAtMessageNACK("AT+SEND=",8);
            for (j = 0; j < 4; j++) { 
                sendAtMessageNACK(dataArray[(i*4) + j], lightBufSize);
                sendAtMessageNACK(";",1);
            }
            if(sendAtMessage("\n")) {
                pc.printf("message succesfully sent\n\r");
                //myled = 1;
            }
            wait_ms(1000);
        }
    }
    
    
    while(1) {
        if(pc.readable()) {
            device.putc(pc.getc());
            myled = !myled;
        }
        if(device.readable()) {
            pc.putc(device.getc());
            myled = !myled;
        }
    }
    
}