//このプログラムは2019年大島打上の本番プログラムを参考にしている
#include "mbed.h"                   
#include "MPU6050.h"
#include "BMP180.h"

#define CNT_LAUNCH            //発射判定するときの何かしらのしきい値
#define TIME_SWIM             //強制的にSwimフェーズに移行させる時間
#define TIME_SEND            //無線送信する間隔
#define NUM_CNT_MEDIAN        //中央値をとる個数
#define RATE_GPS             //GPSのTickerを動作させるタイミング

MPU6050 mpu(,);                     //mpu()の使用宣言
BMP180  bmp(,);                     //bmp()の使用宣言
Serial pc(,);                       //パソコンの使用宣言
Serial gps(,);                      //GPSの使用宣言
DigitalOut myled();                 //???
DigitalOut ES920_RST(PA_5);         //???
PwmOut     servo1(PB_4);            //サーボの使用宣言
PwmOut     servo2(PB_5);            //サーボの使用宣言
DigitalOut servo1_signal(PA_0);     //サーボの使用宣言
DigitalOut servo2_signal(PA_1);     //サーボの使用宣言
Timer timer_open;                   //???
Timer timer_data;                   //???
Ticker tic_gps;                     //???

/*自作関数*/
void f_land();                      //着水判定をする関数
void f_swim();                      //サーボを用いて泳ぐ関数
float f_get_gps_length();           //GPSから北方向の位置を返す関数...(1)
float f_get_gps_width();            //GPSから東方向の位置を返す関数...(2)
float f_get_high();                 //から高度を返す関数...(3)
void f_get_gps_full();              //(1)(2)を用いて自身の位置を把握する関数...(4)

void f_get_full();                  //全てのデータを取得し整理する関数。基本的に各フェーズではこの関数に頼る




enum Phaze{                         //フェーズ定義
    STANDBY,
    LEAVE_LAND,
    SWIM,
    FIN
}phaze;

void main()                         //本体はここから
{
    
    while (phaze != FIN){
        switch(phaze){            
            case STANDBY:           //発射検知するまでがSTANDBYフェーズ
                f_get_full();
                if(){  //なんらかの値がしきい値を超えたらフェーズ変更
                    phaze = LEAVE_LAND;
                    }
                break;                
            case LEAVE_LAND:        //着水検知するまでがLEAVE_LANDフェーズ
                f_get_full();
                f_land();
                if(){  //なんらかの値がしきい値を超えたらフェーズ変更
                    phaze = SWIM;
                    }
                break;
            case SWIM:              //ゴールするまでがSWIMフェーズ
                f_get_full();
                if(){  //なんらかの値がしきい値を超えたらフェーズ変更
                    phaze = FIN;
                    }
                
                break;
            }
        }
    
}