#include "mbed.h"
#include "math.h" 
#include "BMP180.h"

#define p0 1013.25f//海面気圧
#define TIME_TOP      16
#define TIME_WATER    94
#define TIME_BUZZER   274
#define NUM           5
#define RATE          20
#define JUDGE_ALT     2.0

enum PHASE{EGG,SERVO,CLOSE,RISE,DROP,BUZZER} Phase;
enum MOVE{HEAT,CRACK,OPEN,HUTA,TOP,HEAT_BUZZER} Move;

PwmOut         servo_crack1(p21);   
PwmOut         servo_crack2(p22);
PwmOut         servo_open1(p23);   
PwmOut         servo_open2(p24);
DigitalIn      rec1(p18);
DigitalIn      rec2(p19);
DigitalOut     heat(p25);  
DigitalOut     buzzer(p16);
DigitalOut     myled1(LED1);
DigitalOut     myled2(LED2);
DigitalOut     myled3(LED3);
DigitalOut     myled4(LED4);
BMP180 bmp     (p28, p27);
LocalFileSystem local("local"); 

Timer          timer_acc;
Timer          timer_top; 
Timer          timer_all;
Ticker         tic_mission;
Ticker         tic_buzzer;
 
bool           Save;
void           _mission(); 
void           _heater_acc(); 
void           _buzzer();
void           _data();
void           _servo();
float          _getAlt(float press, float temp);
float          _median(float data[], int num);
float          Med_alt,Maeno_alt;
float          Pressure,Temperature,Altitude;
float          alt[NUM],max=-5000;
float          t;
int            Cnt_top=0,Cnt_water=0;
int            u=0;

FILE *fp; 

int main(){
    bmp.Initialize(BMP180_OSS_ULTRA_LOW_POWER);
    timer_all.start();
    servo_crack1.period_ms(20);
    servo_crack2.period_ms(20);
    servo_open1.period_ms(20);
    servo_open2.period_ms(20);
    servo_crack1.pulsewidth(0.001);
    servo_crack2.pulsewidth(0.001);
    for(float j=0;j<0.00009;j+=0.00001){
        servo_open1.pulsewidth(0.00099-j);
        wait(0.02);
        servo_open2.pulsewidth(0.00094-j);
        wait(0.02);
    }
    fp = fopen("/local/out.txt", "a"); 
    fprintf(fp,"%f:Hello,World\n\r");
    fclose(fp);
    buzzer=0; 
    _heater_acc(); 
    Phase=EGG;  
    tic_mission.attach(&_mission,1.0/20);
    while(1){
        if(Save){
            _data();
        }
        if(timer_top.read()>=TIME_BUZZER){
            buzzer=0;
        }
    }
}
    
    
void _mission(){
    if(Phase==BUZZER){ 
        _buzzer();
    }
    myled4=!myled4;
    switch(Phase){
        case EGG:            
                        myled1=0;
                        myled2=0;
                        for(float i=0;i<0.00045;i+=0.00005){
                            servo_crack1.pulsewidth(0.001+i);
                            wait(0.02);
                            servo_crack2.pulsewidth(0.001+i);
                            wait(0.02);
                        }            
                        t=timer_all.read();
                        Move=CRACK;
                        _data();
                        Phase=SERVO;
                        break;
                        
        case SERVO:     
                        if(timer_all.read()-t>=0.5){
                            for(float j=0;j<0.00009;j+=0.00001){
                                servo_open1.pulsewidth(0.0009+j);
                                wait(0.02);
                                servo_open2.pulsewidth(0.00085+j);
                                wait(0.02);
                            }
                            Move=OPEN;
                            _data();
                            Save=true;
                            Phase=CLOSE;
                        }
                        break;
                        
        case CLOSE:     
                        if(timer_all.read()-t>=1.5){
                            for(float j=0;j<0.00009;j+=0.00001){
                                servo_open1.pulsewidth(0.00099-j);
                                wait(0.02);
                                servo_open2.pulsewidth(0.00094-j);
                                wait(0.02);
                            }
                            Move=HUTA;
                            _data();
                            Save=true;
                            Phase=RISE;
                        }
                        break;
                            
        case RISE:      
                        for(int j=0;j<NUM;j++){
                            bmp.ReadData(&Temperature,&Pressure);
                            alt[j]=_getAlt(Pressure,Temperature);
                        }
                        Med_alt=_median(alt,NUM);
                        if(Med_alt>max){
                            max=Med_alt;
                            Cnt_top=0;
                        }else if(max-Med_alt>=JUDGE_ALT){
                             Cnt_top++;
                        }
                        if(Cnt_top>=3||timer_acc.read()>=TIME_TOP){
                            myled1=1;
                            timer_top.start();
                            Phase=DROP;
                            Move=TOP;
                            Save=true;
                            _data();
                        }
                        break;
        case DROP:
                        Maeno_alt=Med_alt;
                        for(int i=0;i<NUM;i++){
                            bmp.ReadData(&Temperature,&Pressure);
                            alt[i]=_getAlt(Pressure,Temperature);
                        }
                        Med_alt=_median(alt,NUM);
                        if(Maeno_alt-Med_alt>=-5.0&&Maeno_alt-Med_alt<=5.0){
                            Cnt_water++;
                        }else{
                            Cnt_water=0;
                        }
                        if(Cnt_water>=3||timer_top.read()>=TIME_WATER){
                            myled2=1;
                            buzzer=1;
                            //heat=0;
                            Move=HEAT_BUZZER;
                            _data();
                            Save=true;
                            Phase=BUZZER;
                        }
                        break;
        }  
}

void _heater_acc(){
        heat=0;
        while(1){ 
            if(u!=rec1){
                heat=!heat;
                u=rec1;
                Move=HEAT;
                Save=true;
                _data();
            }
            if(rec2==1){
                heat=1;
                timer_acc.start();
                break;
            }
        }
}

void _buzzer(){
        myled3=!myled3;
        if(rec2==1){
            buzzer=1;
        }else if(rec2==0){
            buzzer=0;
        }
}

float _getAlt(float press, float temp){
    return (pow((p0/press), (1.0f/5.257f))-1.0f)*(temp+273.15f)/0.0065f;
}
     
float _median(float data[], int num){
    float *data_cpy, ans;
    data_cpy = new float[num]; 
    memcpy(data_cpy,data,sizeof(float)*num);
 
    for(int i=0; i<num; i++){
        for(int j=0; j<num-i-1; j++){
            if(data_cpy[j]>data_cpy[j+1]){
                float buff = data_cpy[j+1];
                data_cpy[j+1] = data_cpy[j];
                data_cpy[j] = buff;
            }
        }
    }
    
    if(num%2!=0) ans = data_cpy[num/2];
    else         ans = (data_cpy[num/2-1]+data_cpy[num/2])/2.0;
    delete[] data_cpy;
    return ans;
}  

void _data(){
        Save=false;
        fp = fopen("/local/out.txt", "a"); 
        fprintf(fp,"%f:%d\n\r",timer_all.read(),Move);
        fclose(fp);
}