#include "mbed.h"
#define MAX_RDATA 32

Serial sci(USBTX, USBRX); // tx, rx
BusOut myleds(LED1, LED2, LED3, LED4);
I2C i2c(p28, p27);
const int addr = 0x2E<<1;
PwmOut servo(p22);                      //サーボモータ

extern "C" void mbed_reset();   //リセット関数の宣言

char Rdata[MAX_RDATA];          //受信データ
int speed=100;

unsigned short  sci_i=0;
char cmd[3];
char val[MAX_RDATA-3];
void sci_rx () {
    //受信データが大きすぎる場合
    if(sci_i>MAX_RDATA-1){
        sci_i = MAX_RDATA-1;
        Rdata[sci_i]='\n';
    }
    Rdata[sci_i]=sci.getc();    //受信データの格納
    if(Rdata[sci_i]=='\n'){     //受信データ区切り→コマンドごとの処理
        Rdata[sci_i-1]='\0';
        sci_i=0;
        
        sci.printf("\nReceved data: \"%s\" \r\n", Rdata);
        sscanf(Rdata,"%3s %s", cmd, val);
        //リセット・コマンド
        if(strcmp(cmd, "RST")==0){
            sci.printf("---> Mbed reset \r\n");
            wait(0.1);
            mbed_reset();
        }else
        //パルス設定プログラム
        if(strcmp(cmd, "PWM")==0){
            servo = atof(val)*0.001/2 + 0.03;
            sci.printf("\n---> Set Pulse Width\r\n");
        }else
        //スピードチェンジ・コマンド
        if(strcmp(cmd, "SPD")==0){
            sci.printf("---> Speed change to %fms \r\n", (atof(val)/1000));
            speed=atoi(val);
            if(speed>1000) speed=1000;
        }else
        //トーク・コマンド
        if(strcmp(cmd, "TLK")==0){
            if(strlen(val)+4 > MAX_RDATA-3){
                sci.printf("<!>Error<!> ---> Exceeds size limit\r\n");
            }else{
                sci.printf("---> Now talking \"%s\" \r\n", val);
                strcat(val, ".\r");
                i2c.write(addr, val, strlen(val));
            }
        }else{
        //エラー
            sci.printf("<!>Error<!> ---> Unknown command \r\n");
        }
        strcpy(cmd, ""); strcpy(val, "");
    }else{                      //受信データ区切りでないなら格納続ける
        sci_i++;
    }
    
}

int main() {
    sci.baud(115200);
    sci.attach(sci_rx, Serial::RxIrq);  //シリアル受信割り込み
    int cnt=0;
    
    while(1){
        //LED FLASH
        if(cnt%6<4) myleds = 1 << cnt%6;
        else myleds = 4 >> (cnt%6-4);
        
        cnt++;
        wait((float)speed/1000);
    }
}