/*
説明
Nucleo-F303K8とBMP180を使った気温・気圧・高度計算のサンプルプログラム

ライブラリ
https://developer.mbed.org/users/spiridion/code/BMP180/

以下ピン配置
Nucleo  BMP180
GND-----GND-------0V
+3V3----VIN
D4------SDA
D5------SCL

*/
#include "mbed.h"
#include "math.h"
#include "BMP180.h"
#define p0 1013.25f//海面気圧

DigitalOut myled(LED1);
Serial pc(USBTX,USBRX);
BMP180 bmp(p28, p27);
Timer timer;

float getAlt(float press, float temp);

int main() {
    float pressure,temperature,altitude;
    float time;   
    bmp.Initialize(64,BMP180_OSS_ULTRA_LOW_POWER);
    pc.printf("time, temperature ,pressure, altitude\r\n");
    timer.start();
    
    while(1) {
        bmp.ReadData(&temperature,&pressure);
        altitude = getAlt(pressure,temperature);
        time = timer.read();
        pc.printf("%f, %f, %f, %f \r\n",time, temperature, pressure, altitude);
        myled =! myled;
        wait(1);
    }
}

float getAlt(float press, float temp){
    return (pow((p0/press), (1.0f/5.257f))-1.0f)*(temp+273.15f)/0.0065f;
}