#include "mbed.h"
#include "logger.h"
#include "SDFileSystem.h"
DigitalOut L1(PA_4);
DigitalOut L2(PA_6);
DigitalOut L3(PA_5);
Serial gps(PA_9,PA_10);
Serial pc(PA_2,PA_3);
SDFileSystem sd(PB_5, PB_4, PB_3, PA_15, "sd");
FILE* fp;
LOGGER logg;
Timer t;
float sum = 0;
uint32_t sumCount = 0;
char buffer[14]; 
int log_count=0;
int16_t gyr[3], acc[3], mag[3],Temp;
float mag_init[3];
int COU=0;
int i,rlock,mode;
char gps_data[256];
char ns,ew;
float w_time,hokui,tokei;
float g_hokui,g_tokei;
float d_hokui,m_hokui,d_tokei,m_tokei;
unsigned char c;

void getGPS() {
  c = gps.getc();
  if( c=='$' || i == 256){
    mode = 0;
    i = 0;
    for(int j=0; j<256; j++){
        gps_data[j]=NULL;
    }
  }
  if(mode==0){
    if((gps_data[i]=c) != '\r'){
      i++;
    }else{
      gps_data[i]='\0';
      
      if( sscanf(gps_data, "$GPGGA,%f,%f,%c,%f,%c,%d",&w_time,&hokui,&ns,&tokei,&ew,&rlock) >= 1){
        if(rlock==1){
          L1=1;
          d_tokei= int(tokei/100);
          m_tokei= (tokei-d_tokei*100)/60;
          g_tokei= d_tokei+m_tokei;
          //Latitude
          d_hokui=int(hokui/100);
          m_hokui=(hokui-d_hokui*100)/60;
          g_hokui=d_hokui+m_hokui;
        }
         else{
        }
        sprintf(gps_data, "");
      }
    }
  }
}
int main()
{ 
    i2c.frequency(400000);
    t.start();
    pc.printf("gps start!\r\n");
    gps.baud(9600);
    logg.initialize();
    mkdir("/sd/mydir", 0777);
    FILE *fp=fopen("/sd/test.txt","w");
    fprintf(fp,"start");
    fclose(fp);
    
    gps.attach(getGPS,Serial::RxIrq);
 while(1) {
    FILE *fp = fopen("/sd/test.txt","a");
    COU++;
    fprintf(fp,"ID=%d,",COU);
    fprintf(fp,"%f", t.read());
    logg.readGyroData(gyr);
    logg.readAccelData(acc);
    logg.readMagData(mag);
    Temp = logg.readTempData();
    ax = acc[0] * 2.0 / 32768.0;
    ay = acc[1] * 2.0 / 32768.0;
    az = acc[2] * 2.0 / 32768.0;
    fprintf(fp,"%d, %d, %d,", gyr[0], gyr[1], gyr[2]); 
    fprintf(fp,"%d, %d, %d,", acc[0], acc[1], acc[2]); 
    fprintf(fp,"%f, %f, %f,", ax, ay, az);
    fprintf(fp,"%d, %d, %d", mag[0], mag[1], mag[2]);
    fprintf(fp,"%d,",(Temp/100)); 
    fprintf(fp,"%2.2f, %04.2f", logg.getTemperature(), logg.getPressure());
    fprintf(fp,"%.1f,%.6f,%.6f\n",w_time,g_tokei, g_hokui);
    wait(0.2);
    fclose(fp);
    L1=0;
}
}
