//GEMINIquest_FMprogram
#include "mbed.h"
#include "math.h"
#include "MPU6050.h"
#include "BMP180.h"
#include "Servo.h"
#include "SDFileSystem.h"
#define p0 1013.25f//海面気圧
#define ACC 3      //離床判定基準
#define CNT_LAUNCH_TIMES 5//発射判定に必要な連続数
#define CNT_HIGHEST_ALTITUDE_TIMES 5//頂点判定に必要な、高度が連続して下がる回数
#define CNT_HIGHEST_ALTITUDE_TIME 13.0//頂点判定の最終手段。発射検知してから〇〇秒後には必ずCanSat・パラシュートを放出する    

MPU6050     mpu(p9,p10);
Serial gps(p13,p14);//tx,rx
DigitalOut centerpoint(p22);
Serial pc(USBTX,USBRX);
BMP180 bmp(p28, p27);
Timer timer;
Servo myservo(p23);
SDFileSystem    sd(p5, p6, p7, p8, "sd");
FILE *fp;
FILE *al;
Timer  timer_log;
Timer  cnt_launch;
Timer aaa;

int cnt = 0;        //離床判定カウント
int oldcnt = 0;     //cntが連続して変化しているか調べる
float a[3],a_abs;   //３軸
int countchan = 0;  //頂点判定カウント
int oldcount = 0;
float pressure,temperature,altitude;
float oldaltitude;
float timechan;   
float Time;
char  gps_data[256];
int   cnt_gps;
int   Cnt_GPS=0;
float _DMS2DEG(float raw_data);
float getAlt(float press, float temp);
void readGPS();
int main() {
    pc.printf("ax      ay      az      sum_acc cnt     times\r\n");
    int times=1;
    float aa;
    float after_launch=0.0;
    pc.printf("\r\nstart\r\n");
    myservo = 0.9;
    mpu.setAcceleroRange(0);//kasokudonokihonn 
    bmp.Initialize(64,BMP180_OSS_ULTRA_LOW_POWER);//dozyou
    timer.start();
    mkdir("/sd/mydir",0777);//SDファイル作成
    fp = fopen("/sd/mydir/sdtest.txt", "a");//最初のSDopen時間かかるのでwhile外デ
    al = fopen("/sd/mydir/altitude.txt", "a");
    if(fp == NULL) {
       error("Could not open file for write\n");
    }
    fprintf(fp, "GPS\n\r");
    fprintf(al, "altitude\ttime\n\r");
    fclose(fp);  
    fclose(al);
    aaa.start();
    while(cnt<=CNT_LAUNCH_TIMES) {
        fp = fopen("/sd/mydir/sdtest.txt", "a");
        readGPS();//filenikakikomu
        fclose(fp);
        mpu.getAccelero(a);
        aa = aaa.read();
        a_abs = sqrt(pow(a[0]/9.81,2)+pow(a[1]/9.81,2)+pow(a[2]/9.81,2));//gouseikasokudo x y z 
        pc.printf("%f\t%f\t%f\t",a[1],a[2],a[3]);
        pc.printf("%4.3f\t%d\t%d\t%f\r\n",a_abs,cnt,times,aa);
        times ++;
        if(a_abs > ACC){
            cnt++;
        }
        else if (cnt==oldcnt){
        cnt = 0;
        }
        oldcnt = cnt;
    }
    cnt_launch.start();
    pc.printf("\r\nnow   temp  press alti  count\r\n");
    while(1){
        after_launch = cnt_launch.read();
        bmp.ReadData(&temperature,&pressure);
        oldaltitude =altitude;
        altitude = getAlt(pressure,temperature);
        timechan = timer.read();
        fp = fopen("/sd/mydir/sdtest.txt", "a");
        readGPS();
        fclose(fp);
        al = fopen("/sd/mydir/altitude.txt", "a");
        fprintf(al,"%f\t%f\r\n",altitude,timechan);
        fclose(al);
        pc.printf("%f\t%f\t%f\t%f\t%d\r\n ",timechan, temperature, pressure, altitude,countchan);
        oldcount = countchan;
        if(altitude<oldaltitude)//前の高度よりも低いか？
        {
            countchan++;
        }
        else if(countchan==oldcount)//連続で取れていないか？
        {
            countchan = 0;
        }
        if((CNT_HIGHEST_ALTITUDE_TIMES <= countchan )||(CNT_HIGHEST_ALTITUDE_TIME < after_launch)){//カウントが設定数値以上か？
            pc.printf("\r\n");
            myservo = 0.1;
            while(1)//頂点判定完了
            {
            fp = fopen("/sd/mydir/sdtest.txt", "a");
            readGPS();
            fclose(fp);
            al = fopen("/sd/mydir/altitude.txt", "a");
            fprintf(al,"%f\t%f\r\n",altitude,timechan);
            fclose(al);
            bmp.ReadData(&temperature,&pressure);
            altitude = getAlt(pressure,temperature);
            timechan = timer.read();
            pc.printf("%f\t%f\t%f\t%f \t",time, temperature, pressure, altitude);
            pc.printf("-%d\r\n",countchan);
            while(1);
            }
        }
    }
}
float getAlt(float press, float temp){
    return (pow((p0/press), (1.0f/5.257f))-1.0f)*(temp+273.15f)/0.0065f;
}
float _DMS2DEG(float raw_data)
{
    int d=(int)(raw_data/100);
    float m=(raw_data-(float)d*100);
    return (float)d+m/60;
    }
void readGPS()
{
     //pc.printf("GPS取得成功！\t");
     if(gps.readable()){
            gps_data[cnt_gps] = gps.getc();
            if(gps_data[cnt_gps] == '$' || cnt_gps ==256){
                cnt_gps = 0;
                memset(gps_data,'\0',256);
            }else if(gps_data[cnt_gps] == '\r'){
                float world_time, lon_east, lat_north;
                int rlock, sat_num;
                char lat,lon;
                if(sscanf(gps_data,"GPGGA,%f,%f,%c,%f,%c,%d,%d",&world_time,&lat_north,&lat,&lon_east,&lon,&rlock,&sat_num)>=1){
                    if(rlock==1){
                        lat_north = _DMS2DEG(lat_north);
                        lon_east = _DMS2DEG(lon_east);
                        fprintf(fp, "%s\t",gps_data);
                        fprintf(fp, "Lat:%f,Lon:%f\r\ntime:%f,sat_num:%d\r\n",lat_north,lon_east,world_time,sat_num);
                        pc.printf("%s\t",gps_data);
                        pc.printf("Lat:%f,Lon:%f\r\ntime:%f,sat_num:%d\r\n",lat_north,lon_east,world_time,sat_num);
                    }else{
                        fprintf(fp, "%s\r\n",gps_data);
                        pc.printf("%s\r\n",gps_data);
                    }
                }
            }else{
                cnt_gps++;
            }
            
        }
        if(timer_log.read()>=30.0*60.0) timer_log.reset();
}