#include "mbed.h"
#include "SDFileSystem.h"

Serial pc(USBTX,USBRX);
SDFileSystem sd(p5,p6,p7,p8,"sd");
Ticker ADtimer;
AnalogIn amp1(p15);
AnalogIn amp2(p20);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

unsigned short a_val1[500][5];
unsigned short a_val2[500][5];
unsigned int count[500][5];
unsigned int count1 = 0;
unsigned short gyo=0,retu=0,sdretu1,sdretu2,flag=0;

void adread()
{
    count1++;
    a_val1[gyo][retu] = amp1.read_u16() >> 4;
    a_val2[gyo][retu] = amp2.read_u16() >> 4;
    count[gyo][retu] = count1;
    gyo++;
    
    if(gyo == 500){
        flag = 1;
        gyo = 0;
        sdretu1 = retu;
        retu++;
        if(retu == 5)
            retu = 0;
    }
    
    if((count1%1000)==0) pc.printf("%d,%d\n",a_val1[gyo][retu],a_val2[gyo][retu]);
}

int main() {
    led1 = 1;
    pc.printf("Start up!\r\n");
    ADtimer.attach(&adread,0.001);
    
    while(1) {
        if(flag == 1){
            flag = 0;
            sdretu2 = sdretu1;
            led2 = 1;
            FILE *fp = fopen("/sd/sd.csv","a");
            if(fp == NULL)
                led4 = 1;
            else
                led2 = 1;
            for(int i=0;i<500;i++){
                if(count[i][sdretu2]==1) fprintf(fp, "count, loadcell, pressure\n");
                fprintf(fp, "%d,%d,%d\n",count[i][sdretu2],a_val1[i][sdretu2],a_val2[i][sdretu2]);
            }
            fclose(fp);
            led2 = 0;
        }
    }
}