/*2019.8 能代打ち上げ実験　CanSat用プログラム*/
/*動作試験も本番も全く動かすことなく終わってしまったため，予想と異なる動きをする可能性がある(サイドスラスターの動く無機など)．*/
#include "mbed.h"                   
#include "MPU9250.h"
#include "math.h"
#include "MSCFileSystem.h"

/*重要な定数をここで定義する*/
#define CNT_LAUNCH_MAIN_ACC 3.0     //発射判定するときの加速度の閾値
#define CNT_LAUNCH_CONST 3      //発射判定するときの加速度の閾値を超えなければならない連続数
#define CNT_SWIM_TIME       60  //強制的にSwimフェーズに移行させる時間の閾値　
#define CNT_FIN_DISTANCE_M  100     //ゴール判定の距離の閾値[m]　
#define NUM_CNT_MEDIAN      3       //中央値をとる個数　
#define NUM_CNT_LAND_TEST   2      //発射判定時にメジアン値が乗り越えなければならない回数
#define O_X 40.24164                        //目標地点のgps座標のx軸　(当日決定)
#define O_Y 140.0108                        //目標地点のgps座標のy軸
#define DETECTION_NUM       3       //検知に使うデータの数（配列の要素数として扱う）(あまり重要ではない)
#define N_N 220//地磁気がこの値より大きければ北を指す
#define MIDDLE_N 50//地磁気がこの値より大きければ北東か北西を指す
#define S_S -200//地磁気がこの値より小さければを南を指す(本番では間違えてこことこの下の値を逆にしていた．)
#define MIDDLE_S -50//地磁気がこの値より大きければ南東か南西を指す
#define BIAS 9 //偏角
#define M_PI 3.1415926//円周率
#define IDO_PER 111120 //緯度一度分の距離
#define KEDO_PER 84989 //軽度一度分の距離（緯度一度分の距離×cos緯度）　今回は秋田県（緯度40度）で考えた 



enum Phaze{                         //フェーズ定義
    STANDBY,
    LEAVE_LAND,
    SWIM,
    FIN
};

enum direct{                  //  方向範囲を番号付けする（だけ）列挙子
    n_n,
    n_e,
    e_e,
    s_e,
    s_s,
    s_w,
    w_w,
    n_w,
};

enum right_left{                    //右回りか左回りか
    right,
    left,
    straight,
};


float sum = 0;//ここらへんはソースコードのコピペで，不必要なものもあるかもしれない．
uint32_t sumCount = 0;
char buffer[14];

/*各種使用機器の定義*/
Timer t;
Timer timer_all;
Timer second_timer;
PwmOut suisin(p23);
PwmOut servo_l(p21);//右左逆だったらここを入れ替えればいい 
PwmOut servo_r(p22);
MSCFileSystem msc("usb");
Serial gps(p13,p14);//(tx,rx) gpsの使用するとしてmbedの13,14ピンを用いるという宣言
MPU9250 mpu9250;
Timer t_a;
Serial pc(USBTX, USBRX); // tx, rx
char gps_data[256];
float gpstime,gpsido,gpskeido,dido,mido,dkeido,mkeido;
char ns,ew;
int ht,mt,st;//計算結果 時刻
float ido,keido;//計算結果
int gps_i;
bool Sateliterock =0;
int AmountSatelite;
int dummy;
DigitalOut L1(LED1);



/*自作関数*/
/*関数を多用することで，実行動作の部品化やデバッグの効率化を図る*/

float _DMS2DEG(float raw_data)
/*gps_catchのための関数（60進数->100進数）*/
{
    int d=(int)(raw_data/100);
    float m=(raw_data-(float)d*100);
    return (float)d+m/60;
}

void GPS()
{
    
      if( (gps_data[gps_i]=gps.getc()) != '$'){
       // pc.printf("*** Error! ***\r\n");
        gps_i++;
        if(gps_i==255){
       //    pc.printf("*** Error! ***\r\n");
            gps_data[gps_i]='\0';
            
         }//if
    }else{ gps_data[gps_i]='\0';
      if(sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&gpstime,&gpsido,&ns,&gpskeido,&ew,&dummy,&AmountSatelite) >= 1){
              //hokui
          dido=int(gpsido/100);mido=(gpsido-dido*100)/60;ido=dido+mido;
         //tokei
          dkeido= int(gpskeido/100);mkeido=(gpskeido-dkeido*100)/60;keido=dkeido+mkeido;
            //time set
            ht=int(gpstime/10000);mt=int((gpstime-ht*10000)/100);st=int(gpstime-ht*10000-mt*100);ht=ht+9;//UTC =>JST
            if(AmountSatelite>=1)L1=1;;
    
     }
      gps_i=0;
    
    sprintf(gps_data,"");
      }
      
}

void gps_catch(float *x,float *y)
/*引数x,yにそれぞれ緯度経度を代入する(下の方のwaitは邪魔かもしれない)*/
{
    int i=0;
    gps.attach(GPS, Serial::RxIrq);
    while(i<5){
        //pc.printf("ido = %f , keido = %f\r\nns -> %c , ew -> %c\r\n",ido,keido,ns,ew);
        *x = ido;
        *y = keido;
        wait(0.5);
        i++;
    }    
}

float _median(float *data, int num)
/*有効要素数numの配列data[]の中央値（メジアン）を返す関数 */
{
    float ans;
    for(int i=0; i<num-1; i++){
        for(int j=0; j<num-1-i; j++){
            if(data[j]>data[j+1]){
                float buff = data[j+1];
                data[j+1] = data[j];
                data[j] = buff;
            }
        }
    }

    if(num%2!=0) ans = data[num/2];
    else         ans = (data[num/2-1]+data[num/2])/2.0;
    return ans;
}

int p_vector_catch()
/*地磁気データを受信し自分の方向を返すint型関数(この関数は0.5の遅れを生んでしまう．改善が必要)*/
{
    pc.printf("p_vector\r\n");
    float _mx[NUM_CNT_MEDIAN],_my[NUM_CNT_MEDIAN],_mz[NUM_CNT_MEDIAN];
    int p_vector,i;
    //pc.printf("\n\n\n\n\n\n\n\n\n\n\n");
    pc.baud(9600);  
    i2c.frequency(400000);
    t.start();        
    
    uint8_t whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);
    if (whoami == 0x71)
    {  
        sprintf(buffer, "0x%x", whoami);
        wait(1);
        
        mpu9250.resetMPU9250();
        mpu9250.MPU9250SelfTest(SelfTest); 
        mpu9250.calibrateMPU9250(gyroBias, accelBias);
        mpu9250.initMPU9250(); 
        mpu9250.initAK8963(magCalibration);
    }

        mpu9250.getMres();

    while(1){
        whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);
        if(whoami != 0x71){
            pc.printf("Could not connect to MPU9250: \n\r");
            pc.printf("%#x \n",  whoami);
            sprintf(buffer, "WHO_AM_I 0x%x", whoami);
            wait(1.0);
            continue;
        }
        if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01) {
            for(i=0;i<NUM_CNT_MEDIAN;i++){
            
                mpu9250.readMagData(magCount);
                _mx[i] = (float)magCount[0]*mRes*magCalibration[0] -220;//- magbias[0];
                _my[i] = (float)magCount[1]*mRes*magCalibration[1] -25;//- magbias[1];  
                _mz[i] = (float)magCount[2]*mRes*magCalibration[2] +220;//- magbias[2];
                }
            mx = _median(_mx,NUM_CNT_MEDIAN);
            my = _median(_my,NUM_CNT_MEDIAN);
            mz = _median(_mz,NUM_CNT_MEDIAN);
            
        }
        Now = t.read_us();
        deltat = (float)((Now - lastUpdate)/1000000.0f) ;
        lastUpdate = Now;
            
        sum += deltat;
        sumCount++;

        float ax=0,ay=0,az=0,gx=0,gy=0,gz=0;    
        mpu9250.MahonyQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f, my, mx, mz);

        delt_t = t.read_ms() - count;
        if (delt_t > 500) {//←ここがいらない
            pc.printf("mx = %f my = %f mz = %f  mG  \r\n", mx,my,mz);
            /*y軸がどこを指しているかで場合分け(機体の向きを算出する)*/
            if(N_N < my){//機体が真北を向いている
                p_vector = n_n;    
            }else if(MIDDLE_N < my){
                if(mx < 0){//機体が北西を向いている(x軸とy軸の関係を考慮して場合分けしてる)(gpsを裏返しているのでこの通りになる)
                    p_vector = n_e;
                }else{//機体が北東を向いている
                    p_vector = n_w;
                }
            }else if(MIDDLE_S < my){
                if(mx < 0){//機体が真西を向いている
                    p_vector = e_e;
                }else{//機体が真東を向いている
                    p_vector = w_w;
                }
            }else if(S_S < my){
                if(mx < 0){//機体が南西を向いている
                    p_vector = s_e;
                }else{//機体が南東を向いている
                    p_vector = s_w;
                }
            }else{//機体が真南を向いている
                p_vector = s_s;
            }
            break;
        }
    }
    return p_vector;
}

void usb_write_data(int time,float gps_x,float gps_y)
/*usbに1,2のデータを書き込むvoid型関数*/
{
    FILE *fp= fopen("/usb/test.txt", "a");
    fprintf(fp,"\n%d,",time);//ファイルはCSV表記で記録し，エクセルでインポート出来るようにする
    fprintf(fp,"%f,",gps_x);
    fprintf(fp,"%f,",gps_y);
}

int acc_catch()
/*合成加速度を返す関数(他にもジャイロ・地磁気・姿勢などを扱えるようにソースコードをコメントとして残しておいた)*/
{
    
        float acc_sum;
        // If intPin goes high, all data registers have new data
 

        if(mpu9250.readByte(MPU9250_ADDRESS, INT_STATUS) & 0x01)   // On interrupt, check if data ready interrupt

            mpu9250.readAccelData(accelCount);  // Read the x/y/z adc values
            // Now we'll calculate the accleration value into actual g's
            ax = (float)accelCount[0]*aRes/0.98;// - accelBias[0];  // get actual g value, this depends on scale being set
            ay = (float)accelCount[1]*aRes/0.98;// - accelBias[1];
            az = (float)accelCount[2]*aRes/0.98;// - accelBias[2];
 
            /* mpu9250.readGyroData(gyroCount);  // Read the x/y/z adc values
            // Calculate the gyro value into actual degrees per second
            gx = (float)gyroCount[0]*gRes - gyroBias[0];  // get actual gyro value, this depends on scale being set
            gy = (float)gyroCount[1]*gRes - gyroBias[1];
            gz = (float)gyroCount[2]*gRes - gyroBias[2];
 
            mpu9250.readMagData(magCount);  // Read the x/y/z adc values
            // Calculate the magnetometer values in milliGauss
            // Include factory calibration per data sheet and user environmental corrections
            mx = (float)magCount[0]*mRes*magCalibration[0] - magbias[0];  // get actual magnetometer value, this depends on scale being set
            my = (float)magCount[1]*mRes*magCalibration[1] - magbias[1];
            mz = (float)magCount[2]*mRes*magCalibration[2] - magbias[2];*/
        
 
 
//    if(lastUpdate - firstUpdate > 10000000.0f) {
//     beta = 0.04;  // decrease filter gain after stabilized
//     zeta = 0.015; // increasey bias drift gain after stabilized
//   }
 
        // Pass gyro rate as rad/s
        //uint32_t us = t.read_us();
        //mpu9250.MadgwickQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f,  my,  mx, mz);
        //us = t.read_us()-us;
// mpu9250.MahonyQuaternionUpdate(ax, ay, az, gx*PI/180.0f, gy*PI/180.0f, gz*PI/180.0f, my, mx, mz);
 
        // Serial print and/or display at 0.5 s rate independent of data rates
        // update LCD once per half-second independent of read rate
            pc.printf("ax = %f\t",ax);
            pc.printf("ay = %f\t",ay);
            pc.printf("az = %f\t",az);
            acc_sum = sqrtf(ax*ax + ay*ay + az*az);
            pc.printf("sum = %f mG\t",acc_sum);
 
            /*pc.printf("gx = %f", gx);
            pc.printf(" gy = %f", gy);
            pc.printf(" gz = %f  deg/s\n\r", gz);
 
            pc.printf("gx = %f", mx);
            pc.printf(" gy = %f", my);
            pc.printf(" gz = %f  mG\n\r", mz);
 
            tempCount = mpu9250.readTempData();  // Read the adc values
            temperature = ((float) tempCount) / 333.87f + 21.0f; // Temperature in degrees Centigrade
            pc.printf("temperature = %f  C\n\r", temperature);
 
            pc.printf("q0 = %f\n\r", q[0]);
            pc.printf("q1 = %f\n\r", q[1]);
            pc.printf("q2 = %f\n\r", q[2]);
            pc.printf("q3 = %f\n\r", q[3]);
 
 
 
            // Define output variables from updated quaternion---these are Tait-Bryan angles, commonly used in aircraft orientation.
            // In this coordinate system, the positive z-axis is down toward Earth.
            // Yaw is the angle between Sensor x-axis and Earth magnetic North (or true North if corrected for local declination, looking down on the sensor positive yaw is counterclockwise.
            // Pitch is angle between sensor x-axis and Earth ground plane, toward the Earth is positive, up toward the sky is negative.
            // Roll is angle between sensor y-axis and Earth ground plane, y-axis up is positive roll.
            // These arise from the definition of the homogeneous rotation matrix constructed from quaternions.
            // Tait-Bryan angles as well as Euler angles are non-commutative; that is, the get the correct orientation the rotations must be
            // applied in the correct order which for this configuration is yaw, pitch, and then roll.
            // For more see http://en.wikipedia.org/wiki/Conversion_between_quaternions_and_Euler_angles which has additional links.
            yaw   = atan2(2.0f * (q[1] * q[2] + q[0] * q[3]), q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3]);
            pitch = -asin(2.0f * (q[1] * q[3] - q[0] * q[2]));
            roll  = atan2(2.0f * (q[0] * q[1] + q[2] * q[3]), q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3]);
            pitch *= 180.0f / PI;
            yaw   *= 180.0f / PI;
            yaw   -= 13.8f; // Declination at Danville, California is 13 degrees 48 minutes and 47 seconds on 2014-04-04
            roll  *= 180.0f / PI;
 
            pc.printf("Yaw, Pitch, Roll: %f %f %f\n\r", yaw, pitch, roll);
            pc.printf("average rate = %f\n\r", (float) sumCount/sum);*/
 
            myled= !myled;
    return acc_sum;
}

int flag_launch()
/*発射検知する*/
{
    int phaze,x,acc,constant=0;
    for(x=0;x<CNT_LAUNCH_CONST;x++){
        acc = acc_catch();
        if(acc < CNT_LAUNCH_MAIN_ACC){
            phaze = STANDBY;
            return phaze;
        }
    }
    phaze = LEAVE_LAND;
    return phaze;
}

int flag_land(int time_p)
/*着水検知する*/
{
    if(time_p > CNT_SWIM_TIME)
        return SWIM;
    return LEAVE_LAND;
}

int cal_object_vector(float dis_x,float dis_y)
/*目標ベクトルを8つの方向変数の内から返す*/
{
    int o_vector;
    if(dis_x == 0){//x方向で目標との距離がない場合
        if(0 < dis_y){//ベクトルがy方向に正の値を示す場合
            o_vector = n_n;//機体は北を向いているということ
        }else{//
            o_vector = s_s;//機体は南を向いているということ(x=0かつy=0となってもs_sを入れることになるが，実際はそうなる前にゴール判定が下されているはず)    
        }
    }else if(dis_y == 0){//y方向で目標との距離がない場合(以下同じように考える)
        if(0 < dis_x){
            o_vector = e_e;
        }else{
            o_vector = w_w;
        }
    }else if(dis_x < 0){
        dis_x *= -1;
        if(dis_y < 0){
            dis_y *= -1;
            if(4*dis_x < dis_y){
                o_vector = s_s;
            }else if(4*dis_y < dis_x){
                o_vector = w_w;
            }else{
                o_vector = s_w;
            }
        }else{
            if(4*dis_x < dis_y){
                o_vector = n_n;
            }else if(4*dis_y < dis_x){
                o_vector = w_w;
            }else{
                o_vector = n_w;
            }
        }
    }else{
        if(dis_y < 0){
            dis_y *= -1;
            if(4*dis_x < dis_y){
                o_vector = s_s;
            }else if(4*dis_y < dis_x){
                o_vector = e_e;
            }else{
                o_vector = s_e;
            }
        }else{
            if(4*dis_x < dis_y){
                o_vector = n_n;
            }else if(4*dis_y < dis_x){
                o_vector = e_e;
            }else{
                o_vector = n_e;
            }
        }
    }
    return o_vector;
}

int right_or_left(int o_vector,int p_vector)
/*右回りか左回りか決定する関数*/
{
    int r_l;
    int k = o_vector - p_vector;

    if(k == 0){
        r_l = straight;
    }else if(4 <= k){
        r_l = left;
    }else if(0 < k){
        r_l = right;
    }else if(-4 <= k){
        r_l = left;
    }else {
        r_l = right;
    }
    return r_l;
}

void moter_control(int r_l)
/*モーターを正しい向きに切り替え制御機構発動*/
{
    switch(r_l){
        case straight:
            servo_l = 0.0f;
            servo_r = 0.0f;
            wait(3.0);
            break;
        case right:
            servo_l = 0.0f;
            servo_r = 0.5f;
            wait(1.0);
            servo_l = 0.0f;
            servo_r = 0.0f;
            wait(2.0);
            break;
        case left:
            servo_l = 0.5f;
            servo_r = 0.0f;
            wait(1.0);
            servo_l = 0.0f;
            servo_r = 0.0f;
            wait(2.0);
            break;
    }
}

int flag_fin(int gps_x,int gps_y)
/*ゴール検知*/
{
    int distance_2,x,y,phaze;//distance_2は目標距離からの距離の２乗の値
    x = gps_x - O_X;
    x *= x;
    y = gps_y - O_Y;
    y *= y;
    distance_2 = x+y;//この後にdistanceをm^2になるように何かするべき
    pc.printf("distance = %f\r\n",sqrtf(distance_2));

    if(sqrtf(distance_2) < CNT_FIN_DISTANCE_M)
        phaze = FIN;
    else
        phaze = SWIM;
    return phaze;
}

void bundle_data(float *gps_x,float *gps_y,int time)
/*　usbに書き込むデータを一括して管理する関数*/
{
    usb_write_data(time,*gps_x,*gps_y);
    //wireless_print(*gps_x,*gps_y);
}

int main()                      //本体はここから
{
    /*まずは部品の起動・設定*/
    FILE *fp= fopen("/usb/test3.txt", "a");
    pc.printf("\r\n\n\n\nstart\r\n");
    fprintf(fp,"a");
    pc.printf("a\r\n");
    int i,phaze;
    float gps_x=0.0,gps_y=0.0;
    int o_vector;                //目標方向(1~8)
    int p_vector;                //自分の向いている方向
    int r_or_l;           //方向制御で右回りだったら1左回りだったら0
    int time_p;              //今プロジェクトの重要な時間経過数
    float dis_x,dis_y;

    /*↓設定なしだとモーターは動き出してしまう*/
    suisin = 0.0f;
    servo_l = 0.0f;
    servo_r = 0.0f;
    timer_all.start();   //ここから時間経過を計測

    phaze = STANDBY;       //STANBAYに移行する

    /*加速度センサ設定開始(よくわからない．おまじまいのようなもの)*/
    pc.baud(9600);
    i2c.frequency(400000);  // use fast (400 kHz) I2C
    //isrPin.rise(&mpuisr);
    uint8_t whoami = mpu9250.readByte(MPU9250_ADDRESS, WHO_AM_I_MPU9250);  // Read WHO_AM_I register for MPU-9250
    if (whoami == 0x71) { // WHO_AM_I should always be 0x68 
        mpu9250.resetMPU9250(); // Reset registers to default in preparation for device calibration
        //mpu9250.calibrateMPU9250(gyroBias, accelBias); // Calibrate gyro and accelerometers, load biases in bias registers
        mpu9250.initMPU9250();
        //mpu9250.initAK8963(magCalibration);
    } else {
        while(1);
    }
    mpu9250.getAres(); // Get accelerometer sensitivity
    //mpu9250.getGres(); // Get gyro sensitivity
    //mpu9250.getMres(); // Get magnetometer sensitivity
    /*加速度センサ設定終了*/

    while (phaze != FIN){  //ようやく本編開始
        switch(phaze){            
            case STANDBY:           //発射検知するまでがSTANDBYフェーズ
                pc.printf("STANDBY now\r\n");
                time_p = timer_all.read();
                pc.printf("time_p = %d\r\n",time_p);
                fprintf(fp,"\r\n%d,,,",time_p);
                phaze = flag_launch();
                if(phaze == LEAVE_LAND){
                    time_p = timer_all.read();
                    timer_all.reset();
                    fprintf(fp,"\r\nGo LEAVE_LAND phaze\n");
                }
                break;                
            case LEAVE_LAND:       //着水検知するまでがLEAVE_LANDフェーズ
                //pc.printf("LEAVE_LAND now\r\n");
                time_p = timer_all.read();
                fprintf(fp,"\n%d,,,",time_p);
                phaze = flag_land(time_p);
                if(phaze == SWIM){
                    timer_all.reset();
                    fprintf(fp,"\nGo SWIM Phaze\n");
                }
                break;
            case SWIM:              //ゴールするまでがSWIMフェーズ
                //pc.printf("SWIM now\r\n");
                wait(1);//これいらない
                suisin = 1.0f;//ここからゴールまでずっと推進用モーターを回し続ける
                
                time_p = timer_all.read();
                gps_catch(&gps_x,&gps_y);
                bundle_data(&gps_x,&gps_y,time_p);
                dis_x = (O_X - gps_x)*IDO_PER;//x方向のゴールまでの実際の距離
                dis_y = (O_Y - gps_y)*KEDO_PER;//y方向のゴールまでの実際の距離
                o_vector = cal_object_vector(dis_x,dis_y);
                p_vector = p_vector_catch();
                
                switch(p_vector){//自身の向いている方向を記載する
                    case n_n:
                        pc.printf("p:n_n\r\n");
                        fprintf(fp,",真北,");
                        break;
                    case n_e:
                        pc.printf("p:n_e\r\n");
                        fprintf(fp,",北東,");
                        break;
                    case e_e:
                        pc.printf("p:e_e\r\n");
                        fprintf(fp,",真東,");
                        break;
                    case s_e:
                        pc.printf("p:s_e\r\n");
                        fprintf(fp,",南東,");
                        break;
                    case s_s:
                        pc.printf("p:s_s\r\n");
                        fprintf(fp,",真南,");
                        break;
                    case s_w:
                        pc.printf("p:s_w\r\n");
                        fprintf(fp,",南西,");
                        break;
                    case w_w:
                        pc.printf("p:w_w\r\n");
                        fprintf(fp,",真西,");
                        break;
                    case n_w:
                        pc.printf("p:n_w\r\n");
                        fprintf(fp,",北西,");
                        break;
                }

                r_or_l = right_or_left(o_vector,p_vector);//どちらに向けばよいか定義する
                moter_control(r_or_l);
                phaze = flag_fin(dis_x,dis_y);
                break;
            }
            //pc.printf("loop continue\r\n");
        }
    /*ゴールしたら全て閉じて終了*/
    suisin = 0.0f;
    pc.printf("finish");
    fprintf(fp,"\r\nFinish\r\n");
    fclose(fp);
    time_p = timer_all.read();
    timer_all.stop();
}