#include "mbed.h"
#include "SDFileSystem.h"
#include "MPU6050.h"

#define RATE        100    //サンプリングレート[Hz]
#define SAVE_NUM    100     //一度に保存するデータ数   SAVE_NUM/RATE [s]ごとに保存する

SDFileSystem    sd(p5, p6, p7, p8, "sd");
MPU6050         mpu(p9,p10);
Timer           jikan;
Ticker          get_t;
Serial          pc(USBTX,USBRX);
FILE            *bp;

void _getData();

float   Data[2][SAVE_NUM][7]={0};
int     Data_cnt = 0;
bool    row;

int main(){
    pc.printf("Hello!\r\n");
    mpu.setAcceleroRange(3);
    mpu.setGyroRange(3);
    mkdir("/sd/mydir", 0777);
    bp = fopen("/sd/mydir/data.bin","ab");  //ファイルは作成は時間がかかるため先にやる
    fclose(bp);
    jikan.start();
    get_t.attach(&_getData,1.0/RATE);
    while(1){
        if(Data_cnt==SAVE_NUM){
            Data_cnt=0;
            row = !row;
            bp = fopen("/sd/mydir/data.bin","ab");
            fwrite(&Data[!row][0][0],sizeof(float),7*SAVE_NUM,bp);
            fclose(bp);
        }
        if(jikan.read()==30.0*60.0)jikan.reset();
    }
    return 0;
}

void _getData(){
    Data[row][Data_cnt][0] = jikan.read();
    mpu.getAccelero(&Data[row][Data_cnt][1]);
    mpu.getGyro(&Data[row][Data_cnt][4]);
    Data_cnt++;
}