#include "mbed.h"
#include "Dht11.h"
#include "TSL2561.h"
#include "Keypad.h"
#include "TextLCD.h"
#include "Motor.h"

//Setup a new plant1 data
float p1_tMin=10.0, p1_tMax=19.0;
float p1_lMin=300.0, p1_lMax=50000.0;
float p1_hMin=60.0, p1_hMax=70.0;
//Setup a new plant2 data
float p2_tMin=10.0, p2_tMax=25.0;
float p2_lMin=200.0, p2_lMax=50000.0;
float p2_hMin=10.0, p2_hMax=40.0;
//Setup a new plant3 data
float p3_tMin=15.0, p3_tMax=25.0;
float p3_lMin=100.0, p3_lMax=50000.0;
float p3_hMin=30.0, p3_hMax=70.0;

Serial pc(PTE0,PTE1);
#define _PRINTX(z,x)             if(z==1) .printf(x);
#define _PRINTLNX(z,x)           if(z==1) {.printf(x);        .printf("\r\n");}
#define _PRINTXY(z,x, y)         if(z==1) .printf(x, y);
#define _PRINTLNXY(z,x, y)       if(z==1) {.printf(x, y);     .printf("\r\n");}
 

//Setup a new plant data

Dht11 sensor(PTB0);
TSL2561 tsl2561(TSL2561_ADDR_FLOAT);// Use the tsl2561 sensor
Motor m(PTD2,PTC17,PTC16);//water motor
Motor w(PTD0,PTC13,PTC12);//wind motor

//Setup output
DigitalOut output1(PTD3);  //lighting
DigitalOut m1(PTC13);  //Setup water motor output forward
DigitalOut m2(PTC12);  //Setup water motor output backword
DigitalOut w1(PTC17);  //Setup wind motor output forward
DigitalOut w2(PTC16);  //Setup wind motor output backword

DigitalOut output4(PTD5);  //Setup output
Keypad KeyInput(PTC4,PTC3,PTC0,PTC7,PTC11,PTC10,PTC6,PTC5);
TextLCD lcd(PTB8,PTB9,PTB10,PTB11,PTE2,PTE3,TextLCD::LCD16x2);
//float output1=0,w.speed(0),m.speed(0),output4=0;// lighting// watering// ventilation// heating

         
                                      
               
int main() {
    int val_hud;
    char keym,tempkey;
    uint16_t val_lig;
    float val_tmp,t;  
    m1=1;
    m2=0;
    w1=1;
    w2=0;
    
//    int output1,output2,m.speed,output4;
    
    
    lcd.printf("-----START------");
    wait(2);
    lcd.printf("WELCOME TO 6711");
    wait(3);
    
   
    
    while (1) {
            lcd.printf("Please input the No. of plant");
            wait(0.2);
            keym=KeyInput.ReadKey(); 
            tempkey=keym;
            lcd.cls();
            if (keym!='\0') {
                lcd.printf("The type of plant is %c",keym);
                wait(3);
                lcd.cls();;
                
                //while(keym!='0') {
                while(1) {
                    keym=KeyInput.ReadKey(); // input a key see if it is the key to trun out 
                    if (keym=='\0'){
                        keym=tempkey;
                       }
                    else if (keym!='\0') {
                        lcd.printf("If you want reset, plesee input zer0 !");
                        keym=KeyInput.ReadKey();
                        if (keym=='0'){
                            break;
                            }
                   
                        }
                                      
                    // get temperature and humidity data from sensor
                    sensor.read();
                    t=sensor.getFahrenheit();
                    val_tmp=(t-32)/1.8;
                    val_hud=sensor.getHumidity();
                    lcd.printf("T: %2.1fC\n", val_tmp);
                    lcd.printf("H: %d%%\n",val_hud); 
                    wait(3);
                    lcd.cls();
                    
                    // get light data
                    val_lig = tsl2561.getLuminosity(TSL2561_VISIBLE);     
                    lcd.printf("Illu is:%d Lux\n",val_lig); 
                    wait(2);
                    lcd.cls();
                    
                    // compare data
                    //lcd.printf("key is:%c \n",keym); 
                    //wait(2);
                    if (keym=='1') {
                        if (val_tmp>=p1_tMin && val_tmp<=p1_tMax)   {
                            if (val_hud>=p1_hMin && val_hud<=p1_hMax) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                            
                                
                            else if (val_hud<=p1_hMin ) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.3);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                            else    {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(1);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.9);
                                    m.speed(0.7);
                                    output4=0;
                                    }
                                }
                                
                            
                            }
                        else if (val_tmp<=p1_tMin){
                            if (val_hud>=p1_hMin && val_hud<=p1_hMax){
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(0);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(0);
                                    output4=1;
                                    }
                                }
                                
                            else if (val_hud<=p1_hMin ) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(1);
                                    output4=1;
                                    }
                                }
                            else    {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=1;
                                    }
                                }
                            }
                            
                       
                                
                        else{
                            if (val_hud>=p1_hMin && val_hud<=p1_hMax){
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.8);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.4);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                                
                            else if (val_hud<=p1_hMin ) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.3);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                            else{
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(1);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(1);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                            }
            
                    }
   //-------------------------- sceond type-----------------------------------------   
                    else if (keym=='2') {
                        if (val_tmp>=p2_tMin && val_tmp<=p2_tMax)   {
                            if (val_hud>=p2_hMin && val_hud<=p2_hMax) {
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<p2_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                            
                                
                            else if (val_hud<=p2_hMin ) {
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<p2_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                            else    {
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                                
                            
                            }
                        else if (val_tmp<=p1_tMin){
                            if (val_hud>=p2_hMin && val_hud<=p2_hMax){
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(0);
                                    output4=1;
                                    }
                                else if (val_lig<=p2_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(0);
                                    output4=1;
                                    }
                                }
                                
                            else if (val_hud<=p2_hMin ) {
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(1);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(1);
                                    output4=1;
                                    }
                                }
                            else    {
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=1;
                                    }
                                else if (val_lig<=p2_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=1;
                                    }
                                }
                            }
                            
                       
                                
                        else{
                            if (val_hud>=p2_hMin && val_hud<=p2_hMax){
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<=p2_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                                
                            else if (val_hud<=p2_hMin ) {
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<=p2_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                            else{
                                if (val_lig>=p2_lMin && val_lig<=p2_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<=p2_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                            }
                        }
   //-------------------------- Third type-----------------------------------------   
                    else{
                        if (val_tmp>=p1_tMin && val_tmp<=p1_tMax)   {
                            if (val_hud>=p1_hMin && val_hud<=p1_hMax) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                            
                                
                            else if (val_hud<=p1_hMin ) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                            else    {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                                
                            
                            }
                        else if (val_tmp<=p1_tMin){
                            if (val_hud>=p1_hMin && val_hud<=p1_hMax){
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(0);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(0);
                                    output4=1;
                                    }
                                }
                                
                            else if (val_hud<=p1_hMin ) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0);
                                    m.speed(1);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0);
                                    m.speed(1);
                                    output4=1;
                                    }
                                }
                            else    {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=1;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=1;
                                    }
                                }
                            }
                            
                       
                                
                        else{
                            if (val_hud>=p1_hMin && val_hud<=p1_hMax){
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                                
                            else if (val_hud<=p1_hMin ) {
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(1);
                                    output4=0;
                                    }
                                }
                            else{
                                if (val_lig>=p1_lMin && val_lig<=p1_lMax) {
                                    output1=0;
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                else if (val_lig<=p1_lMin){
                                    output1=1; 
                                    w.speed(0.5);
                                    m.speed(0);
                                    output4=0;
                                    }
                                }
                            }
                        }
                
             
         }
        }
    }
}
