class FILTER
{
private:

    int _Fs;
    int _Fo;
    double _Boost;
    int _Q;
    double _Wo_d;
    double _Wo_d2;
    float _Com_Den;
    float _NC0,_NC1,_NC2,_DC1,_DC2;
    
    float _FilterOutput;
    float _centreTap; //internal node of filter
    float _b0;
    float _b1;
    float _b2;
    float _b3;
    float _b4;

    // A - Denominator coefficients
    float _a0;
    float _a1;
    float _a2;
    float _a3;
    float _a4;

    //Filter Parameters
    float _G;
    float _k;
    float _Wo;
    
    //Filter input Variables
    
    float _xn;//Current Filter input valuew
    float _xnm1;//Old filter inputs
    float _xnm2;
    float _xnm3;
    float _xnm4;

    //Filter Output Variables
    
    float _yn;//Current Filter Output Value
    float _ynm1;
    float _ynm2;
    float _ynm3;
    float _ynm4;


public:
    FILTER(int Fs, int Fo, double Boost, int Q);//Constuctor
    ~FILTER();//Destuctor

    void Define_Filter();//Calculates the coefficeints of the filter    
    void Print_Filter();//Print Filter Coefficients
    
    //Setters
    
    void setvalue(float RAW_input);//Sets the latest xn sample input value
    void Update_Boost(double Boost_New);//Updates the Boost Value 
    void Update_Q(int Q_New);//Sets the Value of Q
    void Update_Fo(int Fo_New);//Update Centre Frequency
    
    void coeff_update(float _Fo_Current,float _Boost_Current,float _Q_Current);
    //void coeff_update();//Update the Filter Coeffiecients

    //Getters
    float getvalue(void);//returns yn
    double Get_Boost();//Gets the Boost Value
    int Get_Q();//Gets the value of Q
    int Get_Fo();   //Gets the current value of Centre Frequency
};



