#include "mbed.h"

DigitalOut myled(LED1);
AnalogIn ain(PB_0);
Serial pc(USBTX, USBRX); // tx, rx
  
double resistinput;
double bridgeR1=218.14;
double bridgeR2=218.96;
double bridgeR3=218.46;
double gainR12=20000;
double gainR34=46200;
double bridgePotential;
double sourceVoltage=5.0;
double strainResist;
double wheatstonePotential;
double dynamicRangePotential;

int main() {
    
    dynamicRangePotential=sourceVoltage*(bridgeR3/(bridgeR3+bridgeR2));
    
    
    while(1) {
        
        resistinput=ain.read();
        wheatstonePotential=sourceVoltage*resistinput*gainR12/gainR34;
        bridgePotential=wheatstonePotential+dynamicRangePotential;
        strainResist=-bridgeR1*bridgePotential/(bridgePotential-sourceVoltage);
        
        pc.printf("Resistance= %f \n", strainResist);
        wait(1);
        }
}

