#include "mbed.h"
#include "TextLCD.h"
#include "rtos.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20);
Serial pc(USBTX, USBRX);

int pacemakerRate=0;
InterruptIn ASignal(p25);
InterruptIn VSignal(p26);
int AVI = 65;
int ASense=0;
int VSense=0;
int modeset;
bool aPace;
DigitalOut APace(p23);
DigitalOut VPace(p24);

DigitalOut APace1(LED1);
DigitalOut VPace1(LED2);

DigitalOut HighAl(LED3);
DigitalOut LowAl(LED4);

InterruptIn ASig(p25);
InterruptIn VSig(p26);

int pacemakerInterval=10;
const int minwait_A=50;
const int minwait_V=50;
int modeSwitchTimeInterval = 1500;
volatile int time_count=0;
int m=0;
int s=0;
int ms=0;
int PVARP=150;

char key_input;
bool changePacemakerInterval;

int LRI=1500;
int URI=600;

int low[4] = {30,40,100,30};
int high[4] = {60,100,175,175};

volatile bool asig=false;
volatile bool vsig=false;

const int sleepModeURI = 1000;
const int sleepModeLRI = 2000;

const int normalModeURI = 600;
const int normalModeLRI = 1500;

const int sportsModeURI = 343;
const int sportsModeLRI = 600;

const int manualModeURI = 343;
const int manualModeLRI = 2000;

int time1_count=0;

int PVAB = 10;
int VRP = 150;

typedef enum Modes {
    Test,
    Normal,
    Sleep,
    Random,
    Sports,
    Manual,
    Observer
};

typedef enum pacemakersend {
    AVIEvent,
    VentricalEvent,
    ManualMode,
    PostVSense
};

typedef enum pacemakerventrical {
    AWait
};

pacemakerventrical pventrical;
pacemakersend psend1;
Modes mode;
//mode=Normal;

Mutex PacemakerMutex;

Thread *pa;
Thread *pv;
Thread *psend;
Thread *aorv;
Thread *pmode;

void resetTimer0();
void resetTimer1();
void AorVPacesend();
void ASignalreceive();
void VSignalreceive();
void PacemakerAtrial();
void PacemakerModes();
void timer0_init();
void timer1_init();
void ASignalreceive();
void updatePacemaker();
//void VSignalreceive();
void PacemakerVentricularInterval();

extern "C" void TIMER0_IRQHandler (void)
{
    if((LPC_TIM0->IR & 0x01) == 0x01) { // if interrupt provided, continue to next line
        LPC_TIM0->IR |= 1 << 0;         // Clear MR0 interrupt flag
        time_count++;                   //increment time_count
    }
}

void timer0_init(void)
{
    LPC_SC->PCONP |=1<1;            //power on the timer
    LPC_TIM0->MR0 = 23980;        //10 msec period i.e the timer count will increment every 10ms
    LPC_TIM0->MCR = 3;              //reset control
    //3 = Interrupt & reset timer0 on match
    //1 = Interrupt only, no reset
    NVIC_EnableIRQ(TIMER0_IRQn);    //enable interrupt
    LPC_TIM0->TCR = 1;              //enable the timer

}

extern "C" void TIMER1_IRQHandler (void)
{
    if((LPC_TIM1->IR & 0x01) == 0x01) { // if interrupt provided, continue to next line
        LPC_TIM1->IR |= 1 << 0;         // Clear MR0 interrupt flag
        time1_count++;                   //increment time_count
    }
}

void timer1_init(void)
{
    LPC_SC->PCONP |=1<1;            //power on the timer
    LPC_TIM1->MR0 = 23980;        //10 msec period i.e the timer count will increment every 10ms
    LPC_TIM1->MCR = 3;              //reset control
    //3 = Interrupt & reset timer0 on match
    //1 = Interrupt only, no reset
    NVIC_EnableIRQ(TIMER1_IRQn);    //enable interrupt
    LPC_TIM1->TCR = 1;              //enable the timer

}

void resetTimer0()
{
    time_count;
    LPC_TIM0->TCR = 0;
    lcd.locate(0,0);
    lcd.printf("%02d:%02d:%02d", m,s,ms);
}

void resetTimer1()
{
    time1_count=0;
    LPC_TIM1->TCR = 0;
    lcd.locate(0,0);
    lcd.printf("%02d:%02d:%02d", m,s,ms);
}


//void VPacesend()
//{
//    VPace=1;
//    VPace1=1;
//    APace=0;
//    APace1=0;
//}

void AorVPacesend(void const* args)
{
    while(1) {
        Thread::signal_wait(0x01);
        if(aPace) {
            pc.printf("Sending APace");
            APace=1;
            VPace1=0;
            APace1=1;
            VPace=0;
        } else {
            pc.printf("Sending VPace");
            VPace=1;
            VPace1=1;
            APace=0;
            APace1=0;
        }
    }
}

void ASignalreceive()
{
    pc.printf("ASignalreceive");
    asig=true;
    vsig=false;
    
}

void VSignalreceive()
{
    pc.printf("VSignalreceive");
    asig=false;
    vsig=true;
    
}
void ASensesend()
{
    pc.printf("ASensesend");
    ASense=1;
    wait(0.002);
    ASense=0;
}


void sound_HighAlarm()
{
    pc.printf("high");
    HighAl=1;
    LowAl=0;
}
void sound_LowAlarm()
{
    pc.printf("low");
    LowAl=1;
    HighAl=0;
}

void updatePacemaker()
{
    int temp = 60/pacemakerInterval;
    pacemakerRate = pacemakerRate + temp;
}
void VSensesend()
{
    pc.printf("VSensesend");
    VSense=1;
    wait(0.002);
    VSense=0;
}

void PacemakerVentricalEvent(void const* args)
{
    pc.printf("enteredpventricalevent");
    while(1) {
        switch(pventrical) {
            case AWait:
                while(vsig==false||ASense==0||VPace==0);
                if(vsig==true) {
                    pc.printf("vsig in");
                    VSensesend();
                    pventrical=AWait;
                    break;
                } else if(ASense==1) {
                    resetTimer0();
                } else if(APace==1) {
                    resetTimer0();
                }
                while(time_count<PVAB);
                while(vsig==false||VPace==0);
                if(vsig==true)
                    pc.printf("vsig in");
                VSensesend();
                resetTimer0();
                while(time_count<VRP);
                break;
        }
    }
}

void PacemakerSend(void const* args)
{
    pc.printf("enteredpsend");
    while(1) {
        switch(psend1) {
            case AVIEvent:
                while(time_count<AVI||VSense==0||mode!=Manual);
                if(time_count>=AVI) {
                    (*aorv).signal_set(0x01);
                    //AorVPacesend("s");
                    psend1=VentricalEvent;
                } else if(mode==Manual) {
                    while (mode==Manual);
                    psend1=AVIEvent;
                } else if(VSense==1)
                    psend1=VentricalEvent;
                break;
            case VentricalEvent:
                while(ASense==0||time_count<LRI||VSense==0||mode!=Manual);
                if(ASense==1) {
                    if(mode==Manual) {
                        while(mode==Manual);
                        psend1=AVIEvent;
                    } else if(VSense==1) {
                        resetTimer0();
                        psend1=PostVSense;
                    } else {
                        resetTimer0();
                        psend1=AVIEvent;
                    }
                }
                break;
            case PostVSense:
                while(mode!=Manual||ASense==0||time_count<LRI-AVI);
                if(mode==Manual) {
                    while(mode==Manual);
                    psend1=AVIEvent;
                } else if(ASense==1) {
                    if(mode==Manual) {
                        while(mode==Manual);
                    } else {
                        resetTimer0();
                        psend1=AVIEvent;
                    }
                } else if(time_count>=LRI-AVI) {
                    while(mode!=Manual);
                    while(mode==Manual);
                    psend1=AVIEvent;
                }
                break;
        }

    }
}

void PacemakerAtrial(void const* args)
{
    pc.printf("enteredpatrial");
    while(1) {
        while(asig==false||APace==0);
        if(asig==true) {
            pc.printf("asig in");
            ASensesend();
        }
        resetTimer0();
        while(VSense==0||VPace==0);
        resetTimer1();
        while(time_count<PVARP);
        while(time1_count<URI);

    }

}
void PacemakerModes(void const* args)
{
    pc.printf("enteredpmodes");
    while(1) {
        if(pc.readable()) {
            key_input = pc.getc();
            if((key_input=='n'||key_input=='N')&&!changePacemakerInterval) {
                mode = Normal;
                pc.printf("Normal");
                LRI=normalModeLRI;
                URI=normalModeURI;
                // (*Pace).signal_set(0x01);
                //resetTimer0();
                modeset=0;
            } else if((key_input=='s'||key_input=='S')&&!changePacemakerInterval) {
                mode=Sleep;
                pc.printf("Sleep");
                modeset=1;
                LRI=sleepModeLRI;
                URI=sleepModeURI;
                // (*Pace).signal_set(0x01);
                //resetTimer0();
            } else if((key_input=='e'||key_input=='E')&&!changePacemakerInterval) {
                mode=Sports;
                pc.printf("Exercise");
                modeset=2;
                LRI=sportsModeLRI;
                URI=sportsModeURI;
                //  (*Pace).signal_set(0x01);
                //resetTimer0();
            } else if((key_input=='m'||key_input=='M')&&!changePacemakerInterval) {
                mode=Manual;
                modeset=3;
                LRI=manualModeLRI;
                URI=manualModeURI;
                aPace=true;
                //(*Pace).signal_set(0x02);
                pc.printf("Manual");
            } else if((key_input=='v'||key_input=='V')&& !changePacemakerInterval) {
                if(mode==Manual) {
                    mode=Manual;
                    pc.printf("Ventricular");
                    // AorVPacesend();
                    aPace=false;
                    (*aorv).signal_set(0x01);
                }
            } else if((key_input=='a'||key_input=='A')&&!changePacemakerInterval) {
                if(mode==Manual) {
                    mode=Manual;
                    //AorVPacesend();
                    pc.printf("Atrial");
                    aPace=true;
                    (*aorv).signal_set(0x01);
                }
            } else if((key_input=='o'||key_input=='O')&&!changePacemakerInterval) {
                int a = 10 + rand() % 80;
                mode=Observer;
                pc.printf("Observer and %u",a);
                pacemakerInterval =a;
            }

        }
    }
}

//void PacemakerDisplay(void const* args)
//{   pc.printf("enteredpdisplay");
//    while(1) {
//        while(VPace==0||VSense==0) {
//            if(time_count<=pacemakerInterval*1000);
//            updatePacemaker();
//        }
//        pc.printf("%u",pacemakerRate);
//        while(time_count<=pacemakerInterval*1000);
//        if(pacemakerRate<low[modeset]) {
//            resetTimer0();
//            sound_LowAlarm();
//            pc.printf("low");
//        } else if(pacemakerRate>high[modeset]) {
//            resetTimer0();
//            pc.printf("high");
//            sound_HighAlarm();
//        } else if(pacemakerRate<=high[modeset]&&pacemakerRate<=low[modeset]) {
//            resetTimer0();
//            pc.printf("Normal");
//        }
//    }
//
//}

int main ()
{
    pc.baud(9600);
    VSignal.rise(&VSignalreceive);
    ASignal.rise(&ASignalreceive);
    timer0_init();
    timer1_init();
    Thread patrial(PacemakerAtrial);
    pa=&patrial;
    Thread pventrical(PacemakerVentricalEvent);
    pv=&pventrical;
    Thread pacesend(PacemakerSend);
    psend=&pacesend;
    Thread pmodes(PacemakerModes);
    pmode=&pmodes;
    Thread aorvpacesend(AorVPacesend);
    aorv=&aorvpacesend;
    //Thread pdisplay(PacemakerDisplay);


    while(1) {
    }
}