#include "mbed.h"
#include "TextLCD.h"
#include "rtos.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20);
Serial pc(USBTX, USBRX);

InterruptIn APace(p23);
InterruptIn VPace(p24);

DigitalOut ASignal(p25);
DigitalOut VSignal(p26);

DigitalOut APaceReceive(LED1);
DigitalOut VPaceReceive(LED2);

DigitalOut ASignal1(LED3);
DigitalOut VSignal1(LED4);

const int minwait_A=50;
const int minwait_V=50;

volatile int t=0;
volatile int k=0;
int m=0;
int s=0;
int ms=0;
int heartInterval;
char key_input;
int testNumber;
bool testResult;

int LRI=1500;
int URI=600;
int heartRate;
volatile bool Areceived=false;
volatile bool Vreceived=false;
bool test=false;
int low[4] = {30,40,100,30};
int high[4] = {60,100,175,175};
int modeset;
int pulses;

const int sleepModeURI = 1000;
const int sleepModeLRI = 2000;

const int normalModeURI = 600;
const int normalModeLRI = 1500;

const int sportsModeURI = 343;
const int sportsModeLRI = 600;

const int manualModeURI = 343;
const int manualModeLRI = 2000;

typedef enum Modes {
    Test,
    Normal,
    Sleep,
    Random,
    Sports,
    Manual,
    Observer
};
Modes mode;

Mutex HeartMutex;

Thread *heartreceive;
Thread *heartsend;
Thread *heartkeyboard;


void resett();
void resetk();
void VPacereceived();
void APacereceived();
void ASignalsend();
void VSignalsend();
void HeartReceive();
void HeartSend();
void HeartKeyBoardModeSwitch();
void sound_lowAlarm();
void sound_highAlarm();


extern "C" void TIMER0_IRQHandler (void)
{
    if((LPC_TIM0->IR & 0x01) == 0x01) { // if MR0 interrupt, proceed
        LPC_TIM0->IR |= 1 << 0;         // Clear MR0 interrupt flag
        t++;
        k++;
    }
}

//Initializing the timer 0
void timer0_init(void)
{

    LPC_SC->PCONP |=1<1;            //Timer0 Power On
    LPC_TIM0->MR0 = 23990;         //1 msec
    LPC_TIM0->MCR = 3;              //interrupt and reset control
    NVIC_EnableIRQ(TIMER1_IRQn);    //Enable timer0 interrupt
    LPC_TIM0->TCR = 1;              //enable Timer0
    t = 0;
    k = 0;
}

void resett()
{
    t=0;
}

void resetk()
{
    k=0;
}

void sound_lowAlarm(){
    pc.printf("lowalarm");}
void sound_highAlarm(){
    pc.printf("highalarm");}
void VPacereceived()
{
    pc.printf("VPace received");
    VPaceReceive=1;
    wait(0.002);
    APaceReceive=0;
    pulses++;
    Vreceived=true;
    Areceived=false;
    if(mode == Test) {
        //(*HeartTxPtr).signal_set(0x04);
    }
    if(mode == Test && test) {
        if(testNumber == 2 || testNumber == 0 || testNumber == 3 || testNumber == 1) {
            testResult = false;
        } else if(testNumber == 6 || testNumber == 4) {
            testResult = true;
        }
    }
}

void APacereceived()
{
    pc.printf("APace received");
    APaceReceive=1;
    wait(0.002);
    APaceReceive=0;
    Areceived=true;
    if(mode == Test && test) {
        if(testNumber == 0) {
            testResult = false;
        } else if(testNumber == 4 || testNumber == 7 || testNumber == 3 || testNumber == 1) {
            testResult = true;
        }
    }
}

void ASignalsend()
{
    ASignal=1;
    ASignal1=1;
    wait(0.02);
    Thread::wait(1);
    ASignal1=0;
    ASignal=0;
}

void VSignalsend()
{
    VSignal=1;
    VSignal1=1;
    wait(0.02);
    Thread::wait(1);
    VSignal1=0;
    VSignal==0;
}

void updateHeart()
{
    int temp = 60/heartInterval;
    heartRate = heartRate + temp;
}
void HeartReceive(void const* args)
{
    while(1) {
        pc.printf("HR");
        while(Areceived==false||Vreceived==false);
        if(Vreceived==true) {
            resett();

        } else if(Areceived==true) {
            resett();
        }
    }
}

void HeartSend(void const* args)
{
    while(!pc.readable()) {
        int r = rand() % 2;
        pc.printf("HS");
        while(t<minwait_V && mode!=Random && (mode==Test || mode==Manual));
        pc.printf("%u",t);
        if(r==0) {
            VSignalsend();
            pc.printf("Vsignal");
            resett();
        } else if(r==1) {
            ASignalsend();
            pc.printf("ASignal");
            resett();
        }
    }
}
void HeartKeyBoardModeSwitch(void const* args)
{
    while(1) {
        if(pc.readable()) {

            key_input = pc.getc();

            if(key_input=='r'||key_input=='R') {
                mode=Random;
                pc.printf("Random");
                HeartSend("s");
            } else if(key_input=='t'||key_input=='T') {
                mode=Test;
                pc.printf("Test");
            } else if(key_input=='m'||key_input=='M') {
                mode=Manual;
                pc.printf("Manual");
            } else if(mode==Manual&&(key_input=='v'||key_input=='V')) {
                mode=Manual;
                VSignalsend();
                pc.printf("Ventricular");
            } else if(mode==Manual&&(key_input=='a'||key_input=='A')) {
                mode=Manual;
                ASignalsend();
                pc.printf("Atrial");
            } else if(key_input=='o'||key_input=='O') {
                int a = 10 + rand() % 80;
                mode=Observer;
                pc.printf("Observer and %u",a);
                heartInterval =a;
                HeartSend("s");
            } else {
                pc.printf("Wrong key, sorry");
            }
        }
    }
}

void display(void const* args)
{
    while(1) {
        Thread::wait(observationInterval/1000);
//        if(mode!=Test) {
//            if(mode!= changeobservationinterval) {
//                avgHeartRate=pulseCount*60000/(obsInterval);
//                pulseCount = 0;
//                updateDisplay();
//
//            }
//        }
        if(!Test) {
            pc.printf("Avg Heart Rate: %02d bpm", heartRate);
            while(!Vreceived||!VSignal==0) {
                updateHeart();
            }
            while(k<=heartInterval*1000);
            if(heartRate>high[mode]) {
                sound_highAlarm();
                heartRate=0;
                resetk();
            } else if(heartRate<low[mode]) {
                sound_lowAlarm();
                heartRate=0;
                resetk();
            } else if(heartRate  >= low[mode]  && heartRate  <= high[mode]) {
                heartRate=0;
                resetk();
            }


        }
    }
}


void testmode(void const* args){
    }


int main()
{
    pc.baud(9600);
    VPace.rise(&VPacereceived);
    APace.rise(&APacereceived);
    timer0_init();
    Thread heartreceive(HeartReceive);
    Thread heartsend(HeartSend);
    Thread heartkeyboard(HeartKeyBoardModeSwitch);
    Thread disPlay(display);

    while(1) {
    }
}