#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
InterruptIn A(p8);
InterruptIn V(p9);
int pacemakerrate;
DigitalOut Apace(p10);
DigitalOut Vpace(p11);
DigitalOut ApaceLED(LED1);
DigitalOut VpaceLED(LED2);
DigitalOut AsigLED(LED3);
DigitalOut VsigLED(LED4);
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2);
Serial pc(USBTX, USBRX);
Queue<char, 16> AVsigpmv;
Queue<char, 16> AVsensepmv;
Queue<char, 16> AVpacepmv;
Queue<char, 16> AVsigpms;
Queue<char, 16> AVsensepms;
Queue<char, 16> AVpacepms;
Queue<char, 16> AVsigpma;
Queue<char, 16> AVsensepma;
Queue<char, 16> AVpacepma;
Queue<char, 16> AVsigpmm;
Queue<char, 16> AVsensepmm;
Queue<char, 16> AVpacepmm;
Queue<char, 16> AVsigpmd;
Queue<char, 16> AVsensepmd;
Queue<char, 16> AVpacepmd;
void PacemakerKeyboardInput(void const *args);
void PacemakerModes(void const *args);

void PacemakerSend(void const *args);
void PaceMakerAtrialInterval(void const *args);
void PaceMakerVentricalInterval(void const *args);
int pacemakerMode;
int modeSwitchTimeInterval = 5000;
int flag=0;
int PVAB;
const int sleepModeURI = 1000;
const int sleepModeLRI = 2000;
const int normalModeURI = 600;
const int normalModeLRI = 1500;
const int sportsModeURI = 343;
const int sportsModeLRI = 600;
const int manualModeURI = 343;
const int manualModeLRI = 2000;
int low[4] = {30,40,100,30};
int high[4] = {60,100,175,175};
int pulses = 0;
int pacemakerInterval = 10;
int newpacemakerInterval;
int heartInterval = 10;
int paceMakerRate = 0;
int heartRate = 0;
int LRI = normalModeLRI;
int URI = normalModeURI;
Timer k;
Timer r;
Timer p;
Timer t_loc;
Timer t;
const int PVARP = 150; 
const int VRP = PVARP; 
const int AVI = 65;
char mode;
char manualPace;
char AorV;
char AorVsense;
Thread Pmki(PacemakerKeyboardInput,(void *) 0); 
Thread Pmm(PacemakerModes,(void *) 0);
//Thread Pms (PacemakerSend, (void *) 0);
//Thread PmA (PaceMakerAtrialInterval, (void *) 0);
//Thread PmV (PaceMakerVentricalInterval, (void *) 0);
void PacemakerKeyboardInput(void const *args){
    pc.printf("type something");
    k.start();
    char input;
    while(true){
        if (pc.readable()){
            
        input=pc.getc();
        if (k.read()>=modeSwitchTimeInterval && flag==0){
            if (input=='F'){
                mode='F';
                Pmm.signal_set(0x1);
                Thread::signal_wait(0x1);
                }
            else if (input=='S'){
                mode='S';
                Pmm.signal_set(0x1);
                Thread::signal_wait(0x1);
                }
            else if (input=='N'){
                mode='N';
                Pmm.signal_set(0x1);
                Thread::signal_wait(0x1);
                }
            else if (input=='O'){
                mode='O';
                input=pc.getc();
                newpacemakerInterval=10*(int)input;
                input=pc.getc();
                newpacemakerInterval=newpacemakerInterval+(int)input;
                Pmm.signal_set(0x1);
                Thread::signal_wait(0x1);
                }
            else if (input=='M'){
                mode='M';
                Pmm.signal_set(0x1);
                Thread::signal_wait(0x1);
                }
            else if (input=='A'){
                if (mode=='M')
                    manualPace='A';
                    Pmm.signal_set(0x1);
                    Thread::signal_wait(0x1);
                    }
                }
            else if (input=='V'){
                if (mode=='M'){

                    manualPace='V';
                    Pmm.signal_set(0x1);
                    Thread::signal_wait(0x1);
                    }
                }
            }
            }
        }
    
    
    
void PacemakerModes(void const *args){
    while(1){
        pc.printf("enter pm mode");
        Thread::signal_wait(0x1);
        if (mode=='F'){
            LRI=sportsModeLRI;
            URI=sportsModeURI;
            Pmki.signal_set(0x1);
            }
        else if (mode=='S'){
            LRI=sleepModeLRI;
            URI=sleepModeURI;
            Pmki.signal_set(0x1);
            }
        else if (mode=='N'){
            LRI=normalModeLRI;
            URI=normalModeURI;
            Pmki.signal_set(0x1);
            }
        else if (mode=='O'){
            pacemakerInterval=newpacemakerInterval;
            Pmki.signal_set(0x1);
            }
        else if (mode=='M'){
            LRI=manualModeLRI;
            URI=manualModeURI;
            Pmki.signal_set(0x1);
            while(1){
                Thread::signal_wait(0x1);
                if (mode=='M'){
                    if (manualPace=='A'){
                        char* element;
                        *element='A';
                        AVpacepms.put(element);
                        AVpacepma.put(element);
                        AVpacepmv.put(element);
                        AVpacepmm.put(element);
                        AVpacepmd.put(element);
                        }
                    else if (manualPace=='V'){
                        char* element;
                        *element='V';
                        AVpacepms.put(element);
                        AVpacepma.put(element);
                        AVpacepmv.put(element);
                        AVpacepmm.put(element);
                        AVpacepmd.put(element);
                        }
                    }
                else {
                    Pmm.signal_set(0x1);
                    Pmki.signal_set(0x1);
                    break;
                    }
                Pmki.signal_set(0x1);
                }
            }
        }
    } 

 void PaceMakerAtrialInterval(void const *args){
    char *AorVsig;
    char *AorVpace;
    char *AorVsense;
    osEvent evt;
    pc.printf("entering atrial interval");
    while (1){
            evt = AVsigpma.get(1);
            if (evt.status == osEventMessage) {
                AorVsig = (char*)evt.value.p;
            }
            if (*AorVsig=='A'){
                AorVsig=0;
                char* element;
                *element='A';
                AVsensepms.put(element);
                AVsensepma.put(element);
                AVsensepmv.put(element);
                AVsensepmm.put(element);
                AVsensepmd.put(element);
                break;
                }
            evt = AVpacepma.get(1);
            if (evt.status == osEventMessage) {
                AorVpace = (char*)evt.value.p;
            }
            if (*AorVpace=='A'){
                AorVpace=0;
                break;
                }
        }
    t.reset();
    while(1){
            osEvent evt = AVsensepma.get(1);
            if (evt.status == osEventMessage) {
                AorVsense = (char*)evt.value.p;
            }
            if (*AorVsense=='V'){
                AorVsense=0;
                break;
                }
            evt = AVsensepma.get(1);
            if (evt.status == osEventMessage) {
                AorVpace = (char*)evt.value.p;
            }
            if (*AorVpace=='V'){
                *AorVpace='V';
                break;
                }
        }
    k.reset();
    while(!(k>=PVARP));
    while(!(t>=URI));
    }   
void updatePacemaker(){
    int temp = 60/pacemakerInterval;
    paceMakerRate = paceMakerRate + temp;
}
void PaceMakerDisplay(void const *args){
    osEvent evt;
    char* AorVsense;
    char* AorVpace;
    while(1){
        
        while(1){
        evt = AVsensepmd.get(1);
        if (evt.status == osEventMessage) {
            AorVsense = (char*)evt.value.p;
            }
        if (*AorVsense=='V'){
            break;
            }
        evt = AVpacepmd.get(1);
        if (evt.status == osEventMessage) {
            AorVpace = (char*)evt.value.p;
            }
        if (*AorVpace=='V'){
            break;
            }
        }
        if (r<=pacemakerInterval*1000){
            updatePacemaker();
            }
        else {
            if (paceMakerRate < low[mode]){
                r.reset();
                paceMakerRate=0;
                }
            else if (paceMakerRate  >= low[mode]  && paceMakerRate  <= high[mode]){
                //high alarm
                r.reset();
                paceMakerRate=0;
                }
            else if (paceMakerRate  > high[mode]){
                //low alarm
                r.reset();
                paceMakerRate=0;
                }
            }
        
        
    }
    }
void PaceMakerVentricalInterval(void const *args){
    char *AorVsig;
    char *AorVsense;
    char *AorVpace;
    osEvent evt;
    while(1){
        while(1){
            evt = AVsigpmv.get(1);
            if (evt.status == osEventMessage) {
                AorVsig = (char*)evt.value.p;
            }
            if (*AorVsig=='V'){
                AorVsig=0;
                char* element;
                *element='V';
                pc.printf("sending V pace");
                AVsensepms.put(element);
                AVsensepma.put(element);
                AVsensepmv.put(element);
                AVsensepmm.put(element);
                AVsensepmd.put(element);
                break;
            }
            evt = AVsensepmv.get(1);
            if (evt.status == osEventMessage) {
                AorVsense = (char*)evt.value.p;
            }
            if (*AorVsense=='A'){
                AorVsense=0;
                p.reset();
                while(!(p>=PVAB));
                while(1){
                    osEvent evt = AVsigpmv.get(1);
                    if (evt.status == osEventMessage) {
                        AorVsig = (char*)evt.value.p;
                        }
                    if (*AorVsig=='V'){
                        AorVsig=0;
                        break;
                        }
                    evt = AVpacepmv.get(1);
                    if (evt.status == osEventMessage) {
                        AorVpace = (char*)evt.value.p;
                        }
                    if (*AorVpace=='V'){
                        char* element;
                        *element='V';
                        AVsensepmv.put(element);
                        break;
                        }
                    p.reset();
                    while(!(p>=VRP));
                }
                break;
            }
            evt = AVpacepmv.get(1);
            if (evt.status == osEventMessage) {
                AorVpace = (char*)evt.value.p;
            }
            if (*AorVpace=='A'){
                AorVpace=0;
                p.reset();
                while(!(p>=PVAB));
                while(1){
                    osEvent evt = AVsigpmv.get(1);
                    if (evt.status == osEventMessage) {
                        AorVsig = (char*)evt.value.p;
                        }
                    if (*AorVsig=='V'){
                        AorVsig=0;
                        break;
                        }
                    evt = AVpacepmv.get(1);
                    if (evt.status == osEventMessage) {
                        AorVpace = (char*)evt.value.p;
                        }
                    if (*AorVpace=='V'){
                        char* element;
                        *element='V';
                        pc.printf("sending V pace");
                        AVsensepms.put(element);
                        AVsensepma.put(element);
                        AVsensepmv.put(element);
                        AVsensepmm.put(element);
                        AVsensepmd.put(element);
                        break;
                        }
                    p.reset();
                    while(!(p.read()>=VRP));
                }
                break;
                }
        }
    }
    
    }
void PacemakerSend(void const *args){
    char *AorV;
    while(1){
        while(1){
            osEvent evt = AVsensepms.get(1);
            if (evt.status == osEventMessage) {
                AorV = (char*)evt.value.p;
            }
            if (*AorV=='A'){
                AorV=0;
                break;
                }
            else if (t.read()>=AVI){
                char* element;
                *element='V';
                AVpacepms.put(element);
                AVpacepmv.put(element);
                AVpacepma.put(element);
                Vpace=1;
                wait(.1);
                Vpace=0;
                break;
                }  
            else if (pacemakerMode==1){
                while(pacemakerMode!=0);
                break;
                }     
        }
        while(1){
            osEvent evt = AVsensepms.get(1);
            if (evt.status == osEventMessage) {
                AorV = (char*)evt.value.p;
            }
            if (*AorV=='A'){
                AorV=0;
                if (pacemakerMode==1){
                    while(pacemakerMode!=0);
                    break;
                    }
                else{
                    t.reset();
                    break;
                    }
                }
            else if (*AorV=='V'){
                AorV=0;
                t.reset();
                while(1){
                    osEvent evt = AVsensepms.get(1);
                    if (evt.status == osEventMessage) {
                        AorV = (char*)evt.value.p;
                    }
                    if (*AorV=='A'){
                        AorV=0;
                        if (pacemakerMode==1){
                            while(pacemakerMode!=0);
                            break;
                            }
                        else{
                            t.reset();
                            break;
                            }
                        }
                    else if (pacemakerMode==1){
                        while(pacemakerMode!=0);
                        break;
                        }
                    else if (t>= LRI-AVI){
                        char* element;
                        *element='A';
                        pc.printf("sending A pace");
                AVpacepms.put(element);
                AVpacepma.put(element);
                AVpacepmv.put(element);
                AVpacepmm.put(element);
                AVpacepmd.put(element);
                        Apace=1;
                        wait(.1);
                        Apace=0;
                        if (pacemakerMode==1){
                            while(pacemakerMode!=0);
                            break;
                            }
                        else{
                            t.reset();
                            break;
                            }
                        }
                    }
            }
            else if (t.read()>=LRI){
                    char* element;
                    pc.printf("sending A pace");
                    *element='A';
                AVpacepms.put(element);
                AVpacepma.put(element);
                AVpacepmv.put(element);
                AVpacepmm.put(element);
                AVpacepmd.put(element);
                    Apace=1;
                    wait(.1);
                    Apace=0;
                    if (pacemakerMode==1){
                        while(pacemakerMode!=0);
                        break;
                        }
                    else{
                        t.reset();
                        break;
                        }
                }
            else if (pacemakerMode==1){
                    while(pacemakerMode!=0);
                    break;
                }
        
            
    }
    }
}
void Asig();
void Vsig();
int main(){
    osEvent evt;
    A.mode(PullDown); 
    char* AorVpace;   
   char* AorVsig;           
    A.rise(Asig);               
    V.mode(PullDown);              
    V.rise(Vsig);               
    
    while(1){
        evt = AVpacepmm.get(1);
        if (evt.status == osEventMessage) {
            AorVpace = (char*)evt.value.p;
        }
        if (*AorVpace=='A'){
            AorVpace=0;
            ApaceLED=1;
            wait(.1);
            ApaceLED=(0);
        }
        else if (*AorVpace=='V'){
            AorVpace=0;
            VpaceLED=1;
            wait(.1);
            VpaceLED=0;
            }
        evt = AVsigpmm.get(1);
        if (evt.status == osEventMessage) {
            AorVsig = (char*)evt.value.p;
        }
        if (*AorVsig=='A'){
            AorVsig=0;
            AsigLED=1;
            wait(.1);
            ApaceLED=(0);
        }
        else if (*AorVsig=='V'){
            AorVsig=0;
            VsigLED=1;
            wait(.1);
            VpaceLED=0;
            }
        lcd.cls();
        lcd.printf("%d", paceMakerRate);
        Thread::wait(15);
        };
}


void Asig() {
char* element;
pc.printf("received A signal");
*element='A';
AVsigpms.put(element);
AVsigpma.put(element);
AVsigpmv.put(element);
AVsigpmm.put(element);
AVsigpmd.put(element);
                             
}
void Vsig() {
char* element;
pc.printf("received V signal");
*element='V';
AVsigpms.put(element);
AVsigpma.put(element);
AVsigpmv.put(element);
AVsigpmm.put(element);
AVsigpmd.put(element);
                             
}
